/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.List;
import java.util.Random;
import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.map.BridgeBlockProvider;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;

public interface LOTRBiomeWrapper {
    public ResourceLocation getBiomeRegistryName();

    public Biome getActualBiome();

    default public double getHorizontalNoiseScale() {
        return 400.0;
    }

    default public float getStrengthOfAddedDepthNoise() {
        return 1.0f;
    }

    default public float getBiomeScaleSignificanceForChunkGen() {
        return 0.9f;
    }

    public float getBiomeTreeAmountForPodzol();

    default public BlockState getGrassForBonemeal(Random rand, BlockPos plantPos) {
        return Blocks.field_150349_c.func_176223_P();
    }

    public List<MobSpawnInfo.Spawners> getSpawnsAtLocation(EntityClassification var1, BlockPos var2);

    default public boolean hasSkyFeatures() {
        return true;
    }

    default public void onGeographicalWaterColorUpdate(int waterColor, Biome biomeObjectInClientRegistry) {
    }

    default public Vector3d alterCloudColor(Vector3d clouds) {
        return clouds;
    }

    default public float getCloudCoverage() {
        return 1.0f;
    }

    default public boolean isFoggy() {
        return false;
    }

    default public boolean hasMountainsMist() {
        return false;
    }

    public Biome.RainType getPrecipitationForRendering();

    public float getTemperatureForSnowWeatherRendering(IWorld var1, BlockPos var2);

    default public ExtendedWeatherType getExtendedWeatherForRendering() {
        return ExtendedWeatherType.NONE;
    }

    default public boolean doesSnowGenerate(boolean defaultDoesSnowGenerate, IWorldReader world, BlockPos pos) {
        return defaultDoesSnowGenerate;
    }

    public static boolean isSnowBlockBelow(IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196604_cC;
    }

    default public boolean doesWaterFreeze(boolean defaultDoesWaterFreeze, IWorldReader world, BlockPos pos, boolean mustBeAtEdge) {
        return defaultDoesWaterFreeze;
    }

    default public float getTemperatureRaw(float defaultTemperatureAtPos, BlockPos pos) {
        return defaultTemperatureAtPos;
    }

    public boolean isRiver();

    public Biome getRiver(IWorld var1);

    public LOTRBiomeBase getShore();

    default public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.PATH;
    }

    default public BridgeBlockProvider getBridgeBlockProvider() {
        return BridgeBlockProvider.OAK;
    }

    public boolean isSurfaceBlockForNPCSpawn(BlockState var1);
}

