/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.awt.Color;
import lotr.common.LOTRMod;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.SeaBiome;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.gen.PerlinNoiseGenerator;

public class LOTRGrassColorModifiers {
    public static final BiomeAmbience.GrassColorModifier NORTHLANDS = LOTRGrassColorModifiers.createModifier("northlands", LOTRGrassColorModifiers.noiseGrassModifier(11501635, 13945160, 0.05, 0.003));
    public static final BiomeAmbience.GrassColorModifier FOROCHEL = LOTRGrassColorModifiers.createModifier("forochel", LOTRGrassColorModifiers.noiseGrassModifier(12365701, 6312501, 0.05, 0.03));
    public static final BiomeAmbience.GrassColorModifier SEA = LOTRGrassColorModifiers.createModifier("sea", (x, z, grassColor) -> {
        World world = LOTRMod.PROXY.getClientWorld();
        Biome biome = world.func_226691_t_(new BlockPos(MathHelper.func_76128_c((double)x), 0, MathHelper.func_76128_c((double)z)));
        float adjustedTemp = SeaBiome.getAdjustedTemperatureForGrassAndFoliage((IWorldReader)world, biome, (int)z);
        adjustedTemp = MathHelper.func_76131_a((float)adjustedTemp, (float)0.0f, (float)1.0f);
        float downfall = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
        return GrassColors.func_77480_a((double)adjustedTemp, (double)downfall);
    });
    private static final PerlinNoiseGenerator NOISE_GEN_TUNDRA_GRASS = LOTRBiomeBase.makeSingleLayerPerlinNoise(2971944500256852478L);

    private static BiomeAmbience.GrassColorModifier createModifier(String name, BiomeAmbience.GrassColorModifier.ColorModifier func) {
        String fullName = "lotr_" + name;
        return BiomeAmbience.GrassColorModifier.create((String)fullName.toUpperCase(), (String)fullName, (BiomeAmbience.GrassColorModifier.ColorModifier)func);
    }

    private static BiomeAmbience.GrassColorModifier.ColorModifier noiseGrassModifier(int color1, int color2, double scale1, double scale2) {
        float[] rgb1 = new Color(color1).getColorComponents(null);
        float[] rgb2 = new Color(color2).getColorComponents(null);
        return (x, z, grassColor) -> {
            double d1 = NOISE_GEN_TUNDRA_GRASS.func_215464_a(x * scale1, z * scale1, false);
            double d2 = NOISE_GEN_TUNDRA_GRASS.func_215464_a(x * scale2, z * scale2, false);
            float noise = (float)MathHelper.func_151237_a((double)((d1 *= 0.4) + d2), (double)-1.0, (double)1.0);
            noise += 1.0f;
            noise /= 2.0f;
            float[] rgbNoise = new float[rgb1.length];
            for (int l = 0; l < rgbNoise.length; ++l) {
                rgbNoise[l] = MathHelper.func_219799_g((float)noise, (float)rgb1[l], (float)rgb2[l]);
            }
            return new Color(rgbNoise[0], rgbNoise[1], rgbNoise[2]).getRGB();
        };
    }
}

