/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.BaseGondorBiome;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import lotr.common.world.gen.feature.TreeCluster;
import net.minecraft.block.Blocks;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class LamedonBiome
extends BaseGondorBiome {
    public LamedonBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.2f).func_205420_b(0.2f).func_205414_c(0.7f).func_205417_d(0.9f), major);
    }

    protected LamedonBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setGrass(11646287);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        super.setupSurface(config);
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.4, 0.07).threshold(0.35).state(Blocks.field_196660_k).topOnly()));
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        super.addBoulders(builder);
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 16, 4);
    }

    protected int getLamedonBaseTreeRate() {
        return 0;
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, this.getLamedonBaseTreeRate(), 0.1f, TreeCluster.of(10, 20), LOTRBiomeFeatures.oak(), 5000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakBees(), 50, LOTRBiomeFeatures.oakFancyBees(), 10, LOTRBiomeFeatures.birch(), 500, LOTRBiomeFeatures.birchFancy(), 100, LOTRBiomeFeatures.birchBees(), 5, LOTRBiomeFeatures.birchFancyBees(), 1, LOTRBiomeFeatures.beech(), 500, LOTRBiomeFeatures.beechFancy(), 100, LOTRBiomeFeatures.beechBees(), 5, LOTRBiomeFeatures.beechFancyBees(), 1, LOTRBiomeFeatures.larch(), 3000, LOTRBiomeFeatures.aspen(), 3000, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.pear(), 50, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pearBees(), 1);
        LOTRBiomeFeatures.addGrass(this, builder, 8);
        LOTRBiomeFeatures.addDoubleGrass(builder, 1);
        LOTRBiomeFeatures.addPlainsFlowers(builder, 3, new Object[0]);
        LOTRBiomeFeatures.addDefaultDoubleFlowers(builder, 1, new Object[0]);
        LOTRBiomeFeatures.addAthelasChance(builder);
        LOTRBiomeFeatures.addWildPipeweedChance(builder, 24);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        this.addHorsesDonkeys(builder, 6);
        this.addExtraSheep(builder, 3);
    }

    public static class Hills
    extends LamedonBiome {
        public Hills(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.6f).func_205420_b(0.9f).func_205414_c(0.6f).func_205417_d(0.7f), major);
            this.biomeColors.resetGrass();
        }

        @Override
        protected int getLamedonBaseTreeRate() {
            return 1;
        }

        @Override
        public Biome getRiver(IWorld world) {
            return null;
        }
    }
}

