/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class LongMarshesBiome
extends LOTRBiomeBase {
    private static final int LONG_MARSHES_WATER_COLOR = 8167049;

    public LongMarshesBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.22f).func_205420_b(0.0f).func_205414_c(0.5f).func_205417_d(0.9f), 8167049, major);
        this.biomeColors.setSky(13230818).setFog(12112325).setFoggy(true).setWater(8167049);
    }

    @Override
    public float getStrengthOfAddedDepthNoise() {
        return 0.15f;
    }

    @Override
    public float getBiomeScaleSignificanceForChunkGen() {
        return 0.96f;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setMarsh(true);
    }

    @Override
    protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addQuagmire(builder, 2);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 500, LOTRBiomeFeatures.oakFancy(), 100, LOTRBiomeFeatures.oakSwamp(), 1000, LOTRBiomeFeatures.oakShrub(), 3000, LOTRBiomeFeatures.oakDead(), 500, LOTRBiomeFeatures.spruce(), 500, LOTRBiomeFeatures.spruceDead(), 500, LOTRBiomeFeatures.fir(), 200, LOTRBiomeFeatures.pine(), 200};
        LOTRBiomeFeatures.addTreesBelowTreeline(this, builder, 1, 0.5f, 63, weightedTrees);
        LOTRBiomeFeatures.addTreesAboveTreeline(this, builder, 3, 0.5f, 64, weightedTrees);
        LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, builder, 6);
        LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(builder, 12);
        LOTRBiomeFeatures.addSwampFlowers(builder, 2, new Object[0]);
        LOTRBiomeFeatures.addMoreMushroomsFreq(builder, 3);
        LOTRBiomeFeatures.addWaterLilies(builder, 4);
        LOTRBiomeFeatures.addSwampSeagrass(builder);
        LOTRBiomeFeatures.addFallenLogs(builder, 1);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        super.addReeds(builder);
        LOTRBiomeFeatures.addMoreSwampReeds(builder);
        LOTRBiomeFeatures.addSwampRushes(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
    }

    @Override
    public Biome getRiver(IWorld world) {
        return null;
    }
}

