/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class LothlorienBiome
extends LOTRBiomeBase {
    public LothlorienBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.1f).func_205420_b(0.3f).func_205414_c(0.8f).func_205417_d(0.8f), major);
    }

    protected LothlorienBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setGrass(12837416);
        this.biomeColors.setFog(16770660);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setPodzol(false);
        config.setSurfaceNoisePaths(true);
    }

    @Override
    protected void addOres(BiomeGenerationSettings.Builder builder) {
        super.addOres(builder);
        LOTRBiomeFeatures.addEdhelvirOre(builder);
    }

    @Override
    protected void addCobwebs(BiomeGenerationSettings.Builder builder) {
    }

    @Override
    protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addWhiteSandSediments(builder);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTrees(this, builder, 3, 0.1f, LOTRBiomeFeatures.mallorn(), 3000, LOTRBiomeFeatures.mallornBees(), 30, LOTRBiomeFeatures.mallornBoughs(), 6000, LOTRBiomeFeatures.oak(), 3000, LOTRBiomeFeatures.oakFancy(), 500, LOTRBiomeFeatures.oakBees(), 30, LOTRBiomeFeatures.oakFancyBees(), 5, LOTRBiomeFeatures.larch(), 2000, LOTRBiomeFeatures.beech(), 1000, LOTRBiomeFeatures.beechFancy(), 200, LOTRBiomeFeatures.beechBees(), 10, LOTRBiomeFeatures.beechFancyBees(), 2, LOTRBiomeFeatures.aspen(), 1000, LOTRBiomeFeatures.aspenLarge(), 200, LOTRBiomeFeatures.lairelosse(), 500);
        LOTRBiomeFeatures.addGrass(this, builder, 8);
        LOTRBiomeFeatures.addDoubleGrass(builder, 2);
        LOTRBiomeFeatures.addForestFlowers(builder, 6, LOTRBlocks.ELANOR.get(), 20, LOTRBlocks.NIPHREDIL.get(), 20);
        LOTRBiomeFeatures.addTreeTorches(builder, 120, 60, 110, ((Block)LOTRBlocks.GOLD_MALLORN_WALL_TORCH.get()).func_176223_P(), ((Block)LOTRBlocks.BLUE_MALLORN_WALL_TORCH.get()).func_176223_P(), ((Block)LOTRBlocks.GREEN_MALLORN_WALL_TORCH.get()).func_176223_P(), ((Block)LOTRBlocks.SILVER_MALLORN_WALL_TORCH.get()).func_176223_P());
    }

    @Override
    protected void addLiquidSprings(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addWaterSprings(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        this.addHorsesDonkeys(builder, 4);
        this.addDeer(builder, 2);
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.GALADHRIM_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MALLORN_PLANKS.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.MALLORN_FENCE.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.GOLD_MALLORN_TORCH.get()).func_176223_P(), 1).func_227407_a_(((Block)LOTRBlocks.BLUE_MALLORN_TORCH.get()).func_176223_P(), 1).func_227407_a_(((Block)LOTRBlocks.GREEN_MALLORN_TORCH.get()).func_176223_P(), 1).func_227407_a_(((Block)LOTRBlocks.SILVER_MALLORN_TORCH.get()).func_176223_P(), 1));
    }

    public static class Eaves
    extends LothlorienBiome {
        public Eaves(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.8f).func_205417_d(0.8f), major);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addTrees(this, builder, 2, 0.5f, LOTRBiomeFeatures.mallorn(), 500, LOTRBiomeFeatures.mallornBees(), 5, LOTRBiomeFeatures.mallornBoughs(), 100, LOTRBiomeFeatures.oak(), 3000, LOTRBiomeFeatures.oakFancy(), 500, LOTRBiomeFeatures.oakBees(), 30, LOTRBiomeFeatures.oakFancyBees(), 5, LOTRBiomeFeatures.larch(), 2000, LOTRBiomeFeatures.beech(), 1000, LOTRBiomeFeatures.beechFancy(), 200, LOTRBiomeFeatures.beechBees(), 10, LOTRBiomeFeatures.beechFancyBees(), 2, LOTRBiomeFeatures.aspen(), 1000, LOTRBiomeFeatures.aspenLarge(), 200);
            LOTRBiomeFeatures.addGrass(this, builder, 10);
            LOTRBiomeFeatures.addDoubleGrass(builder, 3);
            LOTRBiomeFeatures.addForestFlowers(builder, 2, LOTRBlocks.ELANOR.get(), 10, LOTRBlocks.NIPHREDIL.get(), 10);
        }
    }
}

