/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import net.minecraft.block.Blocks;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class NindalfBiome
extends LOTRBiomeBase {
    private static final int NINDALF_WATER_COLOR = 8362365;

    public NindalfBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.22f).func_205420_b(0.0f).func_205414_c(0.5f).func_205417_d(1.0f), 8362365, major);
        this.biomeColors.setGrass(6519879).setFoliage(6976836).setSky(9740163).setClouds(8687218).setFog(7500388).setWater(8362365);
    }

    @Override
    public float getStrengthOfAddedDepthNoise() {
        return 0.15f;
    }

    @Override
    public float getBiomeScaleSignificanceForChunkGen() {
        return 0.96f;
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        config.setMarsh(true);
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.4, 0.07).threshold(0.455).state(Blocks.field_196660_k).topOnly()));
    }

    @Override
    protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addQuagmire(builder, 2);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 24, 3);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 200, LOTRBiomeFeatures.oakSwamp(), 600, LOTRBiomeFeatures.oakShrub(), 10000, LOTRBiomeFeatures.oakDead(), 500, LOTRBiomeFeatures.spruce(), 1500, LOTRBiomeFeatures.spruceDead(), 1000};
        LOTRBiomeFeatures.addTreesBelowTreeline(this, builder, 1, 0.5f, 63, weightedTrees);
        LOTRBiomeFeatures.addTreesAboveTreeline(this, builder, 2, 0.5f, 64, weightedTrees);
        LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, builder, 12);
        LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(builder, 10);
        LOTRBiomeFeatures.addSwampFlowers(builder, 1, new Object[0]);
        LOTRBiomeFeatures.addDeadBushAtSurfaceChance(builder, 4);
        LOTRBiomeFeatures.addMoreMushroomsFreq(builder, 3);
        LOTRBiomeFeatures.addWaterLilies(builder, 3);
        LOTRBiomeFeatures.addSwampSeagrass(builder);
        LOTRBiomeFeatures.addFallenLogs(builder, 2);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        super.addReeds(builder);
        LOTRBiomeFeatures.addSwampRushes(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
    }

    @Override
    public Biome getRiver(IWorld world) {
        return null;
    }
}

