/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.BaseGondorBiome;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.biome.surface.SurfaceNoiseMixer;
import lotr.common.world.gen.feature.TreeCluster;
import net.minecraft.block.Block;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;

public class PelargirBiome
extends BaseGondorBiome {
    public PelargirBiome(boolean major) {
        super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.08f).func_205420_b(0.2f).func_205414_c(1.0f).func_205417_d(1.0f), major);
    }

    @Override
    protected void setupSurface(MiddleEarthSurfaceConfig config) {
        super.setupSurface(config);
        config.setSurfaceNoiseMixer(SurfaceNoiseMixer.createNoiseMixer(SurfaceNoiseMixer.Condition.conditionBuilder().noiseIndex(1).scales(0.3, 0.015).zScales(2.333, 4.0).weights(4, 10).threshold(0.5).state(LOTRBlocks.WHITE_SAND)));
    }

    @Override
    protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addWhiteSandSediments(builder);
    }

    @Override
    protected void addBoulders(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.WHITE_SANDSTONE.get()).func_176223_P(), 1, 3, 24, 3);
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.05f, TreeCluster.of(6, 50), LOTRBiomeFeatures.oak(), 5000, LOTRBiomeFeatures.oakFancy(), 1000, LOTRBiomeFeatures.oakBees(), 50, LOTRBiomeFeatures.oakFancyBees(), 10, LOTRBiomeFeatures.birch(), 1000, LOTRBiomeFeatures.birchFancy(), 500, LOTRBiomeFeatures.birchBees(), 10, LOTRBiomeFeatures.birchFancyBees(), 5, LOTRBiomeFeatures.cypress(), 5000, LOTRBiomeFeatures.cedar(), 4000, LOTRBiomeFeatures.cedarLarge(), 500);
        LOTRBiomeFeatures.addGrass(this, builder, 8);
        LOTRBiomeFeatures.addDoubleGrass(builder, 1);
        LOTRBiomeFeatures.addPlainsFlowers(builder, 4, LOTRBlocks.MALLOS.get(), 50);
        LOTRBiomeFeatures.addAthelasChance(builder);
        LOTRBiomeFeatures.addWildPipeweedChance(builder, 24);
    }

    @Override
    protected void addReeds(BiomeGenerationSettings.Builder builder) {
        super.addReeds(builder);
        LOTRBiomeFeatures.addSugarCane(builder);
    }

    @Override
    public LOTRBiomeBase getShore() {
        return LOTRBiomes.WHITE_BEACH.getInitialisedBiomeWrapper();
    }
}

