/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import lotr.common.init.LOTRBlocks;
import lotr.common.util.LOTRUtil;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeFeatures;
import lotr.common.world.biome.surface.MiddleEarthSurfaceConfig;
import lotr.common.world.gen.feature.TreeCluster;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;

public class ShireBiome
extends LOTRBiomeBase {
    public ShireBiome(boolean major) {
        this(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.15f).func_205420_b(0.3f).func_205414_c(0.8f).func_205417_d(0.7f), major);
    }

    protected ShireBiome(Biome.Builder builder, boolean major) {
        super(builder, major);
        this.biomeColors.setGrass(8111137);
    }

    @Override
    protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCommonGranite(builder);
    }

    protected final Object[] shireTrees() {
        return new Object[]{LOTRBiomeFeatures.oak(), 10000, LOTRBiomeFeatures.oakFancy(), 4000, LOTRBiomeFeatures.oakBees(), 100, LOTRBiomeFeatures.oakFancyBees(), 40, LOTRBiomeFeatures.birch(), 250, LOTRBiomeFeatures.birchFancy(), 100, LOTRBiomeFeatures.birchBees(), 2, LOTRBiomeFeatures.birchFancyBees(), 1, LOTRBiomeFeatures.aspen(), 500, LOTRBiomeFeatures.aspenLarge(), 100, LOTRBiomeFeatures.apple(), 50, LOTRBiomeFeatures.appleBees(), 1, LOTRBiomeFeatures.pear(), 50, LOTRBiomeFeatures.pearBees(), 1, LOTRBiomeFeatures.cherry(), 20, LOTRBiomeFeatures.cherryBees(), 1};
    }

    @Override
    protected void addVegetation(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addTreesWithClusters(this, builder, 0, 0.2f, TreeCluster.of(10, 6), this.shireTrees());
        LOTRBiomeFeatures.addShireGrass(this, builder, 8);
        LOTRBiomeFeatures.addPlainsFlowers(builder, 3, new Object[0]);
        LOTRBiomeFeatures.addDefaultDoubleFlowers(builder, 1, new Object[0]);
        LOTRBiomeFeatures.addSunflowers(builder, 6);
        LOTRBiomeFeatures.addWildPipeweedChance(builder, 6);
    }

    @Override
    protected void addLiquidSprings(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addWaterSprings(builder);
    }

    @Override
    protected void addAnimals(MobSpawnInfo.Builder builder) {
        super.addAnimals(builder);
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_220356_B, 5, 2, 4));
    }

    @Override
    protected void addStructures(BiomeGenerationSettings.Builder builder) {
        LOTRBiomeFeatures.addCraftingMonument(builder, ((Block)LOTRBlocks.HOBBIT_CRAFTING_TABLE.get()).func_176223_P(), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.PINE_PLANKS.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)LOTRBlocks.PINE_FENCE.get()).func_176223_P(), 1), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(Blocks.field_150478_aa.func_176223_P(), 1));
    }

    @Override
    public RoadBlockProvider getRoadBlockProvider() {
        return RoadBlockProvider.PATH.withStandardHedge();
    }

    public static class Marshes
    extends ShireBiome {
        public Marshes(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(-0.22f).func_205420_b(0.0f).func_205414_c(0.8f).func_205417_d(1.2f), major);
            this.biomeColors.resetGrass();
        }

        @Override
        public float getStrengthOfAddedDepthNoise() {
            return 0.15f;
        }

        @Override
        public float getBiomeScaleSignificanceForChunkGen() {
            return 0.96f;
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setMarsh(true);
        }

        @Override
        protected void addBiomeSandSediments(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addQuagmire(builder, 1);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            Object[] weightedTrees = new Object[]{LOTRBiomeFeatures.oak(), 500, LOTRBiomeFeatures.oakFancy(), 100, LOTRBiomeFeatures.oakSwamp(), 1000, LOTRBiomeFeatures.oakShrub(), 2500};
            LOTRBiomeFeatures.addTreesBelowTreeline(this, builder, 2, 0.5f, 63, weightedTrees);
            LOTRBiomeFeatures.addTreesAboveTreeline(this, builder, 3, 0.5f, 64, weightedTrees);
            LOTRBiomeFeatures.addGrassWithFernsWithoutPrettyTypes(this, builder, 8);
            LOTRBiomeFeatures.addDoubleGrassWithFernsWithoutPrettyTypes(builder, 8);
            LOTRBiomeFeatures.addSwampFlowers(builder, 4, new Object[0]);
            LOTRBiomeFeatures.addMoreMushroomsFreq(builder, 3);
            LOTRBiomeFeatures.addWaterLiliesWithRareFlowers(builder, 4);
            LOTRBiomeFeatures.addSwampSeagrass(builder);
            LOTRBiomeFeatures.addFallenLogs(builder, 2);
            LOTRBiomeFeatures.addWildPipeweedChance(builder, 3);
        }

        @Override
        protected void addReeds(BiomeGenerationSettings.Builder builder) {
            super.addReeds(builder);
            LOTRBiomeFeatures.addMoreSwampReeds(builder);
            LOTRBiomeFeatures.addSwampRushes(builder);
        }

        @Override
        protected void addAnimals(MobSpawnInfo.Builder builder) {
        }

        @Override
        protected void addStructures(BiomeGenerationSettings.Builder builder) {
        }

        @Override
        public Biome getRiver(IWorld world) {
            return null;
        }
    }

    public static class WhiteDowns
    extends ShireBiome {
        public WhiteDowns(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.7f).func_205420_b(0.6f).func_205414_c(0.6f).func_205417_d(0.8f), major);
            this.biomeColors.resetGrass();
        }

        @Override
        protected void setupSurface(MiddleEarthSurfaceConfig config) {
            super.setupSurface(config);
            config.setFillerDepth(0.0);
            config.addSubSoilLayer(((Block)LOTRBlocks.DIRTY_CHALK.get()).func_176223_P(), 1);
            config.addSubSoilLayer(((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 4);
        }

        @Override
        protected void addStoneVariants(BiomeGenerationSettings.Builder builder) {
            super.addStoneVariants(builder);
            LOTRBiomeFeatures.addDiorite(builder);
        }

        @Override
        protected void addBoulders(BiomeGenerationSettings.Builder builder) {
            super.addBoulders(builder);
            LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 3, 80, 3);
            LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 1, 1, 16, 3);
            LOTRBiomeFeatures.addBoulders(builder, ((Block)LOTRBlocks.CHALK.get()).func_176223_P(), 2, 3, 32, 2);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addTrees(this, builder, 0, 0.08f, this.shireTrees());
            LOTRBiomeFeatures.addShireMoorsGrass(this, builder, 6);
            LOTRBiomeFeatures.addMoorsDoubleGrass(builder, 1);
            LOTRBiomeFeatures.addPlainsFlowers(builder, 2, LOTRBlocks.SHIRE_HEATHER.get(), 20);
            LOTRBiomeFeatures.addWildPipeweedChance(builder, 12);
        }

        @Override
        protected void addAnimals(MobSpawnInfo.Builder builder) {
            super.addAnimals(builder);
        }
    }

    public static class Moors
    extends ShireBiome {
        public Moors(boolean major) {
            super(new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.6f).func_205420_b(0.6f).func_205414_c(0.6f).func_205417_d(1.0f), major);
            this.biomeColors.resetGrass();
        }

        @Override
        protected void addBoulders(BiomeGenerationSettings.Builder builder) {
            super.addBoulders(builder);
            LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 1, 2, 8, 4);
            LOTRBiomeFeatures.addBoulders(builder, Blocks.field_150348_b.func_176223_P(), 3, 5, 40, 3);
        }

        @Override
        protected void addVegetation(BiomeGenerationSettings.Builder builder) {
            LOTRBiomeFeatures.addTrees(this, builder, 0, 0.1f, LOTRUtil.combineVarargs(this.shireTrees(), LOTRBiomeFeatures.oakFancy(), 80000, LOTRBiomeFeatures.oakFancyBees(), 800));
            LOTRBiomeFeatures.addShireMoorsGrass(this, builder, 6);
            LOTRBiomeFeatures.addMoorsDoubleGrass(builder, 1);
            LOTRBiomeFeatures.addPlainsFlowers(builder, 10, LOTRBlocks.SHIRE_HEATHER.get(), 100);
            LOTRBiomeFeatures.addWildPipeweedChance(builder, 12);
        }

        @Override
        protected void addAnimals(MobSpawnInfo.Builder builder) {
            super.addAnimals(builder);
        }
    }
}

