/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.List;
import lotr.common.init.LOTRBiomes;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeWrapper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;

public class VanillaPlaceholderLOTRBiome
implements LOTRBiomeWrapper {
    private final ResourceLocation biomeName;
    private final Biome biome;

    private VanillaPlaceholderLOTRBiome(ResourceLocation name, Biome b) {
        this.biomeName = name;
        this.biome = b;
    }

    public static VanillaPlaceholderLOTRBiome makeWrapperFor(IWorld world, Biome biome) {
        ResourceLocation biomeName = LOTRBiomes.getBiomeRegistryName(biome, world);
        if (biomeName.func_110624_b().equals("lotr")) {
            throw new IllegalArgumentException(String.format("Cannot wrap a LOTR mod biome (%s) in a vanilla placeholder wrapper!", biomeName));
        }
        return new VanillaPlaceholderLOTRBiome(biomeName, biome);
    }

    @Override
    public final ResourceLocation getBiomeRegistryName() {
        return this.biomeName;
    }

    @Override
    public final Biome getActualBiome() {
        return this.biome;
    }

    @Override
    public float getBiomeTreeAmountForPodzol() {
        return 0.5f;
    }

    @Override
    public List<MobSpawnInfo.Spawners> getSpawnsAtLocation(EntityClassification creatureType, BlockPos pos) {
        return this.biome.func_242433_b().func_242559_a(creatureType);
    }

    @Override
    public Biome.RainType getPrecipitationForRendering() {
        return this.biome.func_201851_b();
    }

    @Override
    public float getTemperatureForSnowWeatherRendering(IWorld world, BlockPos pos) {
        return this.biome.func_242445_k();
    }

    @Override
    public boolean isRiver() {
        return this.biome.func_201856_r() == Biome.Category.RIVER;
    }

    @Override
    public Biome getRiver(IWorld world) {
        return LOTRBiomes.getBiomeByRegistryName(Biomes.field_76781_i.func_240901_a_(), world);
    }

    @Override
    public LOTRBiomeBase getShore() {
        return LOTRBiomes.BEACH.getInitialisedBiomeWrapper();
    }

    @Override
    public boolean isSurfaceBlockForNPCSpawn(BlockState state) {
        return state.func_177230_c() == this.biome.func_242440_e().func_242502_e().func_204108_a().func_177230_c();
    }
}

