/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import lotr.common.block.DripstoneBlock;
import lotr.common.world.gen.feature.DripstoneFeatureConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class DripstoneFeature
extends Feature<DripstoneFeatureConfig> {
    public DripstoneFeature(Codec<DripstoneFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, DripstoneFeatureConfig config) {
        boolean placedAny = false;
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        for (int l = 0; l < config.tries; ++l) {
            BlockState placeState;
            int x = pos.func_177958_n() - rand.nextInt(config.xspread) + rand.nextInt(config.xspread);
            int y = pos.func_177956_o() - rand.nextInt(config.yspread) + rand.nextInt(config.yspread);
            int z = pos.func_177952_p() - rand.nextInt(config.zspread) + rand.nextInt(config.zspread);
            movingPos.func_181079_c(x, y, z);
            Block above = world.func_180495_p(movingPos.func_177984_a()).func_177230_c();
            Block below = world.func_180495_p(movingPos.func_177977_b()).func_177230_c();
            boolean waterlogged = world.func_204610_c((BlockPos)movingPos).func_206886_c() == Fluids.field_204546_a;
            boolean isForcedBlock = config.hasForcedDripstoneState();
            boolean canPlaceStalac = isForcedBlock ? ((BlockState)config.forcedBlockState.func_206870_a(DripstoneBlock.DRIPSTONE_TYPE, (Comparable)((Object)DripstoneBlock.Type.STALACTITE))).func_196955_c((IWorldReader)world, (BlockPos)movingPos) : DripstoneBlock.BLOCK_TO_DRIPSTONE.containsKey(above);
            boolean canPlaceStalag = isForcedBlock ? ((BlockState)config.forcedBlockState.func_206870_a(DripstoneBlock.DRIPSTONE_TYPE, (Comparable)((Object)DripstoneBlock.Type.STALAGMITE))).func_196955_c((IWorldReader)world, (BlockPos)movingPos) : DripstoneBlock.BLOCK_TO_DRIPSTONE.containsKey(below);
            boolean placed = false;
            if (canPlaceStalac) {
                BlockState stalac;
                BlockState blockState = stalac = isForcedBlock ? config.forcedBlockState : DripstoneBlock.BLOCK_TO_DRIPSTONE.get(above).func_176223_P();
                if (this.canDripstoneReplace(stalac, (IWorld)world, (BlockPos)movingPos)) {
                    if (rand.nextFloat() < config.doubleChance && this.canDripstoneReplace(stalac, (IWorld)world, movingPos.func_177977_b())) {
                        boolean waterloggedDown = world.func_204610_c(movingPos.func_177977_b()).func_206886_c() == Fluids.field_204546_a;
                        placeState = this.waterlogIfApplicable((BlockState)stalac.func_206870_a(DripstoneBlock.DRIPSTONE_TYPE, (Comparable)((Object)DripstoneBlock.Type.STALACTITE_DOUBLE_BASE)), waterlogged);
                        BlockState placeStateDown = this.waterlogIfApplicable((BlockState)stalac.func_206870_a(DripstoneBlock.DRIPSTONE_TYPE, (Comparable)((Object)DripstoneBlock.Type.STALACTITE_DOUBLE_POINT)), waterloggedDown);
                        world.func_180501_a((BlockPos)movingPos, placeState, 2);
                        world.func_180501_a(movingPos.func_177977_b(), placeStateDown, 2);
                        placed = true;
                    } else {
                        BlockState placeState2 = this.waterlogIfApplicable((BlockState)stalac.func_206870_a(DripstoneBlock.DRIPSTONE_TYPE, (Comparable)((Object)DripstoneBlock.Type.STALACTITE)), waterlogged);
                        world.func_180501_a((BlockPos)movingPos, placeState2, 2);
                        placed = true;
                    }
                }
            }
            if (!placed && canPlaceStalag) {
                BlockState stalag;
                BlockState blockState = stalag = isForcedBlock ? config.forcedBlockState : DripstoneBlock.BLOCK_TO_DRIPSTONE.get(below).func_176223_P();
                if (this.canDripstoneReplace(stalag, (IWorld)world, (BlockPos)movingPos)) {
                    if (rand.nextFloat() < config.doubleChance && this.canDripstoneReplace(stalag, (IWorld)world, movingPos.func_177984_a())) {
                        boolean waterloggedUp = world.func_204610_c(movingPos.func_177984_a()).func_206886_c() == Fluids.field_204546_a;
                        placeState = this.waterlogIfApplicable((BlockState)stalag.func_206870_a(DripstoneBlock.DRIPSTONE_TYPE, (Comparable)((Object)DripstoneBlock.Type.STALAGMITE_DOUBLE_BASE)), waterlogged);
                        BlockState placeStateUp = this.waterlogIfApplicable((BlockState)stalag.func_206870_a(DripstoneBlock.DRIPSTONE_TYPE, (Comparable)((Object)DripstoneBlock.Type.STALAGMITE_DOUBLE_POINT)), waterloggedUp);
                        world.func_180501_a((BlockPos)movingPos, placeState, 2);
                        world.func_180501_a(movingPos.func_177984_a(), placeStateUp, 2);
                        placed = true;
                    } else {
                        BlockState placeState3 = this.waterlogIfApplicable((BlockState)stalag.func_206870_a(DripstoneBlock.DRIPSTONE_TYPE, (Comparable)((Object)DripstoneBlock.Type.STALAGMITE)), waterlogged);
                        world.func_180501_a((BlockPos)movingPos, placeState3, 2);
                        placed = true;
                    }
                }
            }
            placedAny |= placed;
        }
        return placedAny;
    }

    private boolean canDripstoneReplace(BlockState state, IWorld world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j) {
            Block block = state.func_177230_c();
            return block instanceof DripstoneBlock && ((DripstoneBlock)block).isWaterloggable;
        }
        return false;
    }

    private BlockState waterlogIfApplicable(BlockState state, boolean waterlogged) {
        Block block = state.func_177230_c();
        if (block instanceof DripstoneBlock && ((DripstoneBlock)block).isWaterloggable) {
            state = (BlockState)state.func_206870_a((Property)DripstoneBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        }
        return state;
    }
}

