/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.serialization.Codec;
import lotr.common.init.LOTRTags;
import lotr.common.init.RegistryOrderHelper;
import lotr.common.world.gen.feature.BoulderFeature;
import lotr.common.world.gen.feature.BoulderFeatureConfig;
import lotr.common.world.gen.feature.CobwebFeature;
import lotr.common.world.gen.feature.CobwebFeatureConfig;
import lotr.common.world.gen.feature.CraftingMonumentFeature;
import lotr.common.world.gen.feature.CraftingMonumentFeatureConfig;
import lotr.common.world.gen.feature.CrystalFeature;
import lotr.common.world.gen.feature.CrystalFeatureConfig;
import lotr.common.world.gen.feature.DripstoneFeature;
import lotr.common.world.gen.feature.DripstoneFeatureConfig;
import lotr.common.world.gen.feature.FallenLeavesFeature;
import lotr.common.world.gen.feature.FallenLogFeature;
import lotr.common.world.gen.feature.FallenLogFeatureConfig;
import lotr.common.world.gen.feature.GrassPatchFeature;
import lotr.common.world.gen.feature.GrassPatchFeatureConfig;
import lotr.common.world.gen.feature.LatitudeBasedFeature;
import lotr.common.world.gen.feature.LatitudeBasedFeatureConfig;
import lotr.common.world.gen.feature.LeafBushesFeature;
import lotr.common.world.gen.feature.MordorBasaltFeature;
import lotr.common.world.gen.feature.MordorBasaltFeatureConfig;
import lotr.common.world.gen.feature.MordorMossFeature;
import lotr.common.world.gen.feature.MordorMossFeatureConfig;
import lotr.common.world.gen.feature.ReedsFeature;
import lotr.common.world.gen.feature.ReedsFeatureConfig;
import lotr.common.world.gen.feature.TerrainSharpenFeature;
import lotr.common.world.gen.feature.TerrainSharpenFeatureConfig;
import lotr.common.world.gen.feature.TreeTorchesFeature;
import lotr.common.world.gen.feature.UnderwaterSpongeFeature;
import lotr.common.world.gen.feature.WeightedRandomFeature;
import lotr.common.world.gen.feature.WeightedRandomFeatureConfig;
import lotr.common.world.gen.feature.WrappedTreeFeature;
import lotr.common.world.gen.feature.WrappedTreeFeatureConfig;
import lotr.common.world.gen.placement.AtSurfaceLayerLimitedWithExtra;
import lotr.common.world.gen.placement.AtSurfaceLayerLimitedWithExtraConfig;
import lotr.common.world.gen.placement.ByWater;
import lotr.common.world.gen.placement.ByWaterConfig;
import lotr.common.world.gen.placement.TreeClusters;
import lotr.common.world.gen.placement.TreeClustersConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateProvidingFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class LOTRFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"lotr");
    public static final DeferredRegister<Placement<?>> PLACEMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.DECORATORS, (String)"lotr");
    public static final WeightedRandomFeature<?> WEIGHTED_RANDOM = LOTRFeatures.preRegFeature("weighted_random", new WeightedRandomFeature<IFeatureConfig>(WeightedRandomFeatureConfig.CODEC));
    public static final MordorMossFeature MORDOR_MOSS = LOTRFeatures.preRegFeature("mordor_moss", new MordorMossFeature(MordorMossFeatureConfig.CODEC));
    public static final BoulderFeature BOULDER = LOTRFeatures.preRegFeature("boulder", new BoulderFeature(BoulderFeatureConfig.CODEC));
    public static final DripstoneFeature DRIPSTONE = LOTRFeatures.preRegFeature("dripstone", new DripstoneFeature(DripstoneFeatureConfig.CODEC));
    public static final CobwebFeature COBWEBS = LOTRFeatures.preRegFeature("cobwebs", new CobwebFeature(CobwebFeatureConfig.CODEC));
    public static final TerrainSharpenFeature TERRAIN_SHARPEN = LOTRFeatures.preRegFeature("terrain_sharpen", new TerrainSharpenFeature(TerrainSharpenFeatureConfig.CODEC));
    public static final GrassPatchFeature GRASS_PATCH = LOTRFeatures.preRegFeature("grass_patch", new GrassPatchFeature(GrassPatchFeatureConfig.CODEC));
    public static final TreeTorchesFeature TREE_TORCHES = LOTRFeatures.preRegFeature("tree_torches", new TreeTorchesFeature((Codec<BlockStateProvidingFeatureConfig>)BlockStateProvidingFeatureConfig.field_236453_a_));
    public static final CraftingMonumentFeature CRAFTING_MONUMENT = LOTRFeatures.preRegFeature("crafting_monument", new CraftingMonumentFeature(CraftingMonumentFeatureConfig.CODEC));
    public static final CrystalFeature CRYSTALS = LOTRFeatures.preRegFeature("crystals", new CrystalFeature(CrystalFeatureConfig.CODEC));
    public static final LatitudeBasedFeature LATITUDE_BASED = LOTRFeatures.preRegFeature("latitude_based", new LatitudeBasedFeature(LatitudeBasedFeatureConfig.CODEC));
    public static final LeafBushesFeature LEAF_BUSHES = LOTRFeatures.preRegFeature("leaf_bushes", new LeafBushesFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final FallenLogFeature FALLEN_LOG = LOTRFeatures.preRegFeature("fallen_log", new FallenLogFeature(FallenLogFeatureConfig.CODEC));
    public static final ReedsFeature REEDS = LOTRFeatures.preRegFeature("reeds", new ReedsFeature(ReedsFeatureConfig.CODEC));
    public static final UnderwaterSpongeFeature UNDERWATER_SPONGE = LOTRFeatures.preRegFeature("underwater_sponge", new UnderwaterSpongeFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_));
    public static final FallenLeavesFeature FALLEN_LEAVES = LOTRFeatures.preRegFeature("fallen_leaves", new FallenLeavesFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final WrappedTreeFeature WRAPPED_TREE = LOTRFeatures.preRegFeature("wrapped_tree", new WrappedTreeFeature(WrappedTreeFeatureConfig.CODEC));
    public static final MordorBasaltFeature MORDOR_BASALT = LOTRFeatures.preRegFeature("mordor_basalt", new MordorBasaltFeature(MordorBasaltFeatureConfig.CODEC));
    public static final AtSurfaceLayerLimitedWithExtra COUNT_EXTRA_HEIGHTMAP_LIMITED = LOTRFeatures.preRegPlacement("count_extra_heightmap_limited", new AtSurfaceLayerLimitedWithExtra(AtSurfaceLayerLimitedWithExtraConfig.CODEC));
    public static final TreeClusters TREE_CLUSTERS = LOTRFeatures.preRegPlacement("tree_clusters", new TreeClusters(TreeClustersConfig.CODEC));
    public static final ByWater BY_WATER = LOTRFeatures.preRegPlacement("by_water", new ByWater(ByWaterConfig.CODEC));

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FEATURES.register(bus);
        PLACEMENTS.register(bus);
    }

    private static <FC extends IFeatureConfig, F extends Feature<FC>> F preRegFeature(String name, F feature) {
        return (F)RegistryOrderHelper.preRegObject(FEATURES, name, feature);
    }

    private static <PC extends IPlacementConfig, P extends Placement<PC>> P preRegPlacement(String name, P placement) {
        return (P)RegistryOrderHelper.preRegObject(PLACEMENTS, name, placement);
    }

    public static final <FC extends IFeatureConfig> WeightedRandomFeature<FC> getWeightedRandom() {
        return WEIGHTED_RANDOM;
    }

    public static boolean isSurfaceBlock(IWorld world, BlockPos pos) {
        return LOTRFeatures.isSurfaceBlock(world, pos, 0);
    }

    private static boolean isSurfaceBlock(IWorld world, BlockPos pos, int recursion) {
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d()) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Biome biome = world.func_226691_t_(pos);
        ConfiguredSurfaceBuilder surface = (ConfiguredSurfaceBuilder)biome.func_242440_e().func_242500_d().get();
        if (block == surface.field_215454_b.func_204108_a().func_177230_c() || block == surface.field_215454_b.func_204109_b().func_177230_c()) {
            return true;
        }
        if (block.func_203417_a((ITag)BlockTags.field_203436_u) || block.func_203417_a((ITag)BlockTags.field_205599_H) || block.func_203417_a((ITag)Tags.Blocks.GRAVEL) || block.func_203417_a((ITag)Tags.Blocks.DIRT)) {
            return true;
        }
        if (block.func_203417_a(LOTRTags.Blocks.MORDOR_PLANT_SURFACES)) {
            return true;
        }
        return block == Blocks.field_150348_b && recursion <= 1 && LOTRFeatures.isSurfaceBlock(world, pos.func_177977_b(), recursion + 1);
    }

    public static void setGrassToDirtBelow(IWorld world, BlockPos pos) {
        BlockPos belowPos = pos.func_177977_b();
        BlockState belowState = world.func_180495_p(belowPos);
        belowState.func_177230_c().onPlantGrow(belowState, world, belowPos, pos);
    }

    public static void setGrassToDirtBelowDuringChunkGen(IChunk chunk, BlockPos pos) {
        BlockPos belowPos = pos.func_177977_b();
        if (chunk.func_180495_p(belowPos).func_235714_a_((ITag)Tags.Blocks.DIRT)) {
            chunk.func_177436_a(belowPos, Blocks.field_150346_d.func_176223_P(), false);
        }
    }

    public static BlockState getBlockStateInContext(BlockState state, IWorld world, BlockPos pos) {
        return Block.func_199770_b((BlockState)state, (IWorld)world, (BlockPos)pos);
    }
}

