/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.function.IntToDoubleFunction;
import java.util.stream.Collectors;
import lotr.common.world.map.BothWaterLatitudeSettings;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class LatitudeBasedFeatureConfig
implements IFeatureConfig {
    public static final Codec<LatitudeBasedFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredFeature.field_242763_a.fieldOf("feature").forGetter(config -> config.feature), (App)LatitudeConfiguration.CODEC.fieldOf("latitude_config").forGetter(config -> config.latitudeConfig)).apply((Applicative)instance, LatitudeBasedFeatureConfig::new));
    public final ConfiguredFeature<?, ?> feature;
    public final LatitudeConfiguration latitudeConfig;

    public LatitudeBasedFeatureConfig(ConfiguredFeature<?, ?> cf, LatitudeConfiguration lat) {
        this.feature = cf;
        this.latitudeConfig = lat;
    }

    public static class LatitudeConfiguration {
        public static final Codec<LatitudeConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LatitudeValuesType.CODEC.fieldOf("latitude_type").forGetter(config -> config.type), (App)Codec.BOOL.fieldOf("invert").orElse((Object)false).forGetter(config -> config.invert), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("proportional_min").orElse((Object)Float.valueOf(0.0f)).forGetter(config -> Float.valueOf(config.min)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("proportional_max").orElse((Object)Float.valueOf(1.0f)).forGetter(config -> Float.valueOf(config.max))).apply((Applicative)instance, LatitudeConfiguration::new));
        public final LatitudeValuesType type;
        public final boolean invert;
        public final float min;
        public final float max;

        private LatitudeConfiguration(LatitudeValuesType type, boolean invert, float min, float max) {
            this.type = type;
            this.invert = invert;
            this.min = min;
            this.max = max;
        }

        public static LatitudeConfiguration of(LatitudeValuesType type, boolean invert) {
            return new LatitudeConfiguration(type, invert, 0.0f, 1.0f);
        }

        public static LatitudeConfiguration of(LatitudeValuesType type) {
            return LatitudeConfiguration.of(type, false);
        }

        public static LatitudeConfiguration ofInverted(LatitudeValuesType type) {
            return LatitudeConfiguration.of(type, true);
        }

        public LatitudeConfiguration min(float newMin) {
            return new LatitudeConfiguration(this.type, this.invert, newMin, this.max);
        }

        public LatitudeConfiguration max(float newMax) {
            return new LatitudeConfiguration(this.type, this.invert, this.min, newMax);
        }
    }

    public static enum LatitudeValuesType implements IStringSerializable
    {
        ICE("ice", z -> LatitudeValuesType.waterSettings().getIceCoverageForLatitude(z)),
        SAND("sand", z -> LatitudeValuesType.waterSettings().getSandCoverageForLatitude(z)),
        CORAL("coral", z -> LatitudeValuesType.waterSettings().getCoralForLatitude(z));

        public static final Codec<LatitudeValuesType> CODEC;
        private static final Map<String, LatitudeValuesType> NAME_LOOKUP_MAP;
        private final String code;
        private final IntToDoubleFunction zProgressGetter;

        private LatitudeValuesType(String s, IntToDoubleFunction zProgress) {
            this.code = s;
            this.zProgressGetter = zProgress;
        }

        public String func_176610_l() {
            return this.code;
        }

        public static LatitudeValuesType forName(String name) {
            return NAME_LOOKUP_MAP.get(name);
        }

        private static BothWaterLatitudeSettings waterSettings() {
            return MapSettingsManager.serverInstance().getCurrentLoadedMap().getWaterLatitudes();
        }

        public double getLatitudeProgress(int z) {
            return this.zProgressGetter.applyAsDouble(z);
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(LatitudeValuesType::values, LatitudeValuesType::forName);
            NAME_LOOKUP_MAP = Arrays.stream(LatitudeValuesType.values()).collect(Collectors.toMap(LatitudeValuesType::func_176610_l, type -> type));
        }
    }
}

