/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import lotr.common.init.LOTRTags;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.Tags;

public class WrappedTreeFeatureConfig
implements IFeatureConfig {
    public static final Codec<WrappedTreeFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BaseTreeFeatureConfig.field_236676_a_.fieldOf("tree_config").forGetter(config -> config.treeConfig), (App)AlternativeTreeSoil.CODEC.fieldOf("alternative_soil_type").forGetter(config -> config.alternativeSoilType)).apply((Applicative)instance, WrappedTreeFeatureConfig::new));
    public final BaseTreeFeatureConfig treeConfig;
    public final AlternativeTreeSoil alternativeSoilType;

    public WrappedTreeFeatureConfig(BaseTreeFeatureConfig tree, AlternativeTreeSoil soil) {
        this.treeConfig = tree;
        this.alternativeSoilType = soil;
    }

    public static enum AlternativeTreeSoil implements IStringSerializable
    {
        DESERT("desert", state -> state.func_235714_a_((ITag)BlockTags.field_203436_u) || state.func_235714_a_((ITag)Tags.Blocks.SANDSTONE) || state.func_177230_c() == Blocks.field_150348_b),
        CHARRED("mordor", state -> state.func_235714_a_(LOTRTags.Blocks.MORDOR_PLANT_SURFACES) || state.func_177230_c() == Blocks.field_150348_b),
        SNOWY("snowy", state -> state.func_177230_c() == Blocks.field_196604_cC || state.func_177230_c() == Blocks.field_150348_b);

        public static final Codec<AlternativeTreeSoil> CODEC;
        private final String code;
        private final Predicate<BlockState> blockStateTest;

        private AlternativeTreeSoil(String s, Predicate<BlockState> test) {
            this.code = s;
            this.blockStateTest = test;
        }

        public String func_176610_l() {
            return this.code;
        }

        public boolean testTerrain(BlockState state) {
            return this.blockStateTest.test(state);
        }

        public static AlternativeTreeSoil forCode(String code) {
            for (AlternativeTreeSoil type : AlternativeTreeSoil.values()) {
                if (!type.func_176610_l().equals(code)) continue;
                return type;
            }
            return null;
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(AlternativeTreeSoil::values, AlternativeTreeSoil::forCode);
        }
    }
}

