/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lotr.common.world.gen.feature.TreeCluster;
import net.minecraft.world.gen.placement.IPlacementConfig;

public class TreeClustersConfig
implements IPlacementConfig {
    public static final Codec<TreeClustersConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("count").orElse((Object)0).forGetter(config -> config.count), (App)Codec.FLOAT.fieldOf("extra_chance").orElse((Object)Float.valueOf(0.1f)).forGetter(config -> Float.valueOf(config.extraChance)), (App)Codec.INT.fieldOf("extra_count").orElse((Object)1).forGetter(config -> config.extraCount), (App)Codec.INT.fieldOf("cluster_scale").orElse((Object)0).forGetter(config -> config.clusterScale), (App)Codec.INT.fieldOf("cluster_chance").orElse((Object)-1).forGetter(config -> config.clusterChance), (App)Codec.INT.fieldOf("cluster_extra_count").orElse((Object)6).forGetter(config -> config.clusterExtraCount), (App)Codec.INT.fieldOf("cluster_random_extra_count").orElse((Object)4).forGetter(config -> config.clusterRandomExtraCount), (App)Codec.INT.fieldOf("layer_limit").orElse((Object)-1).forGetter(config -> config.layerLimit), (App)Codec.BOOL.fieldOf("is_layer_upper_limit").orElse((Object)false).forGetter(config -> config.isLayerUpperLimit)).apply((Applicative)instance, TreeClustersConfig::new));
    public final int count;
    public final float extraChance;
    public final int extraCount;
    public final int clusterScale;
    public final int clusterChance;
    public final int clusterExtraCount;
    public final int clusterRandomExtraCount;
    public final int layerLimit;
    public final boolean isLayerUpperLimit;

    private TreeClustersConfig(int count, float extraChance, int extraCount, int clusterScale, int clusterChance, int clusterExtraCount, int clusterRandomExtraCount, int layerLimit, boolean isLayerUpperLimit) {
        this.count = count;
        this.extraChance = extraChance;
        this.extraCount = extraCount;
        this.clusterScale = clusterScale;
        this.clusterChance = clusterChance;
        this.clusterExtraCount = clusterExtraCount;
        this.clusterRandomExtraCount = clusterRandomExtraCount;
        this.layerLimit = layerLimit;
        this.isLayerUpperLimit = isLayerUpperLimit;
    }

    public boolean hasLayerLimit() {
        return this.layerLimit >= 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int count = 0;
        private float extraChance = 0.1f;
        private int extraCount = 1;
        private int clusterScale = 0;
        private int clusterChance = -1;
        private int clusterExtraCount = 6;
        private int clusterRandomExtraCount = 4;
        private int layerLimit = -1;
        private boolean isLayerUpperLimit = false;

        private Builder() {
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder extraChance(float extraChance) {
            this.extraChance = extraChance;
            return this;
        }

        public Builder extraCount(int extraCount) {
            this.extraCount = extraCount;
            return this;
        }

        public Builder cluster(TreeCluster cluster) {
            this.clusterScale = cluster.scale;
            this.clusterChance = cluster.chance;
            return this;
        }

        public Builder clusterExtraCount(int clusterExtraCount) {
            this.clusterExtraCount = clusterExtraCount;
            return this;
        }

        public Builder clusterRandomExtraCount(int clusterRandomExtraCount) {
            this.clusterRandomExtraCount = clusterRandomExtraCount;
            return this;
        }

        public Builder layerLimit(int layerLimit, boolean isLayerUpperLimit) {
            this.layerLimit = layerLimit;
            this.isLayerUpperLimit = isLayerUpperLimit;
            return this;
        }

        public TreeClustersConfig build() {
            return new TreeClustersConfig(this.count, this.extraChance, this.extraCount, this.clusterScale, this.clusterChance, this.clusterExtraCount, this.clusterRandomExtraCount, this.layerLimit, this.isLayerUpperLimit);
        }
    }
}

