/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import lotr.common.world.gen.feature.LOTRFeatures;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;

public abstract class ExtendedTrunkPlacer
extends AbstractTrunkPlacer {
    protected final Optional<BlockStateProvider> woodProvider;
    protected final Optional<BlockStateProvider> strippedLogProvider;
    protected final Optional<BlockStateProvider> branchProvider;

    protected static <P extends ExtendedTrunkPlacer> Products.P6<RecordCodecBuilder.Mu<P>, Integer, Integer, Integer, Optional<BlockStateProvider>, Optional<BlockStateProvider>, Optional<BlockStateProvider>> baseCodecWithWood(RecordCodecBuilder.Instance<P> instance) {
        return ExtendedTrunkPlacer.func_236915_a_(instance).and(instance.group((App)BlockStateProvider.field_236796_a_.optionalFieldOf("wood_provider").forGetter(trunk -> trunk.woodProvider), (App)BlockStateProvider.field_236796_a_.optionalFieldOf("stripped_log_provider").forGetter(trunk -> trunk.strippedLogProvider), (App)BlockStateProvider.field_236796_a_.optionalFieldOf("branch_provider").forGetter(trunk -> trunk.branchProvider)));
    }

    protected ExtendedTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, Optional<BlockStateProvider> woodProvider, Optional<BlockStateProvider> strippedLogProvider, Optional<BlockStateProvider> branchProvider) {
        super(baseHeight, heightRandA, heightRandB);
        this.woodProvider = woodProvider;
        this.strippedLogProvider = strippedLogProvider;
        this.branchProvider = branchProvider;
    }

    protected boolean placeWood(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config, Direction.Axis axis) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            BlockState woodState = this.woodProvider.orElseThrow(() -> new IllegalStateException("Wood blockstate provider is not set!")).func_225574_a_(rand, pos);
            if (woodState.func_235901_b_((Property)RotatedPillarBlock.field_176298_M)) {
                woodState = (BlockState)woodState.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axis);
            }
            ExtendedTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)pos, (BlockState)woodState, (MutableBoundingBox)bb);
            trunk.add(pos.func_185334_h());
            return true;
        }
        return false;
    }

    protected boolean placeStrippedLog(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config, Direction.Axis axis) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            BlockState strippedLogState = this.strippedLogProvider.orElseThrow(() -> new IllegalStateException("Stripped log blockstate provider is not set!")).func_225574_a_(rand, pos);
            if (strippedLogState.func_235901_b_((Property)RotatedPillarBlock.field_176298_M)) {
                strippedLogState = (BlockState)strippedLogState.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axis);
            }
            ExtendedTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)pos, (BlockState)strippedLogState, (MutableBoundingBox)bb);
            trunk.add(pos.func_185334_h());
            return true;
        }
        return false;
    }

    protected boolean placeBranch(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            IWorld worldProper;
            BlockState placeState = this.branchProvider.orElseThrow(() -> new IllegalStateException("Branch blockstate provider is not set!")).func_225574_a_(rand, pos);
            if (placeState.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                placeState = (BlockState)placeState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_217375_a(pos, state -> state.func_204520_s().func_206886_c() == Fluids.field_204546_a)));
            }
            if (world instanceof IWorld) {
                worldProper = (IWorld)world;
                placeState = LOTRFeatures.getBlockStateInContext(placeState, worldProper, pos);
            }
            ExtendedTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)pos, (BlockState)placeState, (MutableBoundingBox)bb);
            trunk.add(pos.func_185334_h());
            if (world instanceof IWorld) {
                worldProper = (IWorld)world;
                this.updateNeighboursAfterGeneration(worldProper, pos);
            }
            return true;
        }
        return false;
    }

    protected void growRootsDown(IWorldGenerationReader world, Random rand, BlockPos.Mutable rootPos, int rootLength, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        this.growRootsDownBranchingOut(world, rand, rootPos, rootLength, null, 0, trunk, bb, config);
    }

    protected void growRootsDownBranchingOut(IWorldGenerationReader world, Random rand, BlockPos.Mutable rootPos, int rootLength, Direction outwardsDir, int outwardsInterval, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        int outwardsStartAt;
        int roots = 0;
        int n = outwardsStartAt = outwardsInterval > 0 ? rand.nextInt(outwardsInterval) : 0;
        while (rootPos.func_177956_o() >= 0 && TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)rootPos) && this.placeBranch(world, rand, (BlockPos)rootPos, trunk, bb, config)) {
            if (outwardsDir != null && outwardsInterval > 0 && roots % outwardsInterval == outwardsStartAt) {
                rootPos.func_189536_c(outwardsDir);
            } else {
                rootPos.func_189536_c(Direction.DOWN);
            }
            if (++roots <= rootLength) continue;
            break;
        }
    }

    protected void growRootsDownAndThenOut(IWorldGenerationReader world, Random rand, BlockPos.Mutable rootPos, int rootLength, Direction outwardsDir, int maxOut, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        int roots = 0;
        int numOut = 0;
        while (rootPos.func_177956_o() >= 0 && TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)rootPos) && this.placeBranch(world, rand, (BlockPos)rootPos, trunk, bb, config)) {
            if (world.func_217375_a(rootPos.func_177977_b(), AbstractBlock.AbstractBlockState::func_200132_m)) {
                rootPos.func_189536_c(outwardsDir);
                if (++numOut > maxOut) {
                    break;
                }
            } else {
                rootPos.func_189536_c(Direction.DOWN);
            }
            if (++roots <= rootLength) continue;
            break;
        }
    }

    private void updateNeighboursAfterGeneration(IWorld world, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            BlockPos adjacentPos = pos.func_177972_a(dir);
            BlockState state = world.func_180495_p(adjacentPos);
            BlockState updatedState = LOTRFeatures.getBlockStateInContext(state, world, adjacentPos);
            world.func_180501_a(adjacentPos, updatedState, 19);
        }
    }
}

