/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.Set;
import lotr.common.world.gen.tree.LOTRFoliagePlacers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;

public class LairelosseFoliagePlacer
extends FoliagePlacer {
    public static final Codec<LairelosseFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> LairelosseFoliagePlacer.func_242830_b((RecordCodecBuilder.Instance)instance).and((App)FeatureSpread.func_242254_a((int)0, (int)16, (int)8).fieldOf("trunk_height").forGetter(foliage -> foliage.trunkHeightSpread)).apply((Applicative)instance, LairelosseFoliagePlacer::new));
    private final FeatureSpread trunkHeightSpread;

    public LairelosseFoliagePlacer(FeatureSpread radius, FeatureSpread offset, FeatureSpread trunkHeightSpread) {
        super(radius, offset);
        this.trunkHeightSpread = trunkHeightSpread;
    }

    protected FoliagePlacerType<?> func_230371_a_() {
        return LOTRFoliagePlacers.LAIRELOSSE_FOLIAGE;
    }

    protected void func_230372_a_(IWorldGenerationReader world, Random rand, BaseTreeFeatureConfig config, int p_230372_4_, FoliagePlacer.Foliage foliage, int foliageHeight, int foliageMaxWidth, Set<BlockPos> leaves, int foliageOffset, MutableBoundingBox bb) {
        int layerWidth = 0;
        for (int y = foliageOffset; y >= foliageOffset - foliageHeight; --y) {
            if (y >= foliageOffset - 1) {
                layerWidth = 0;
            } else if (++layerWidth > foliageMaxWidth) {
                layerWidth = 1;
            }
            this.func_236753_a_(world, rand, config, foliage.func_236763_a_(), layerWidth + foliage.func_236764_b_(), leaves, y, foliage.func_236765_c_(), bb);
        }
    }

    public int func_230374_a_(Random rand, int trunkHeight, BaseTreeFeatureConfig config) {
        return Math.max(3, trunkHeight - this.trunkHeightSpread.func_242259_a(rand));
    }

    public int func_230376_a_(Random rand, int trunkHeight) {
        return super.func_230376_a_(rand, trunkHeight);
    }

    protected boolean func_230373_a_(Random rand, int absX, int layerY, int absZ, int layerWidth, boolean bool6) {
        return absX + absZ > layerWidth;
    }
}

