/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import lotr.common.world.gen.tree.ExtendedTrunkPlacer;
import lotr.common.world.gen.tree.LOTRTrunkPlacers;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class MirkOakTrunkPlacer
extends ExtendedTrunkPlacer {
    protected static final Codec<MirkOakTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> MirkOakTrunkPlacer.baseCodecWithWood(instance).apply((Applicative)instance, MirkOakTrunkPlacer::new));
    private final boolean isDead = false;
    private final int trunkWidth = 0;
    private final boolean hasRoots = true;

    protected MirkOakTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, Optional<BlockStateProvider> woodProvider, Optional<BlockStateProvider> strippedLogProvider, Optional<BlockStateProvider> branchProvider) {
        super(baseHeight, heightRandA, heightRandB, woodProvider, strippedLogProvider, branchProvider);
    }

    public MirkOakTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, BlockState wood, BlockState branch) {
        this(baseHeight, heightRandA, heightRandB, Optional.of(new SimpleBlockStateProvider(wood)), Optional.empty(), Optional.of(new SimpleBlockStateProvider(branch)));
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return LOTRTrunkPlacers.MIRK_OAK_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int trunkHeight, BlockPos basePos, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        MirkOakTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)basePos.func_177977_b());
        for (int y = 0; y < trunkHeight; ++y) {
            MirkOakTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)basePos.func_177981_b(y), trunk, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
        }
        ArrayList<FoliagePlacer.Foliage> foliage = new ArrayList<FoliagePlacer.Foliage>();
        this.addLeafCanopy(world, rand, basePos.func_177981_b(trunkHeight - 1), trunk, foliage, bb, config);
        int roots = 4 + rand.nextInt(1);
        for (int l = 0; l < roots; ++l) {
            BlockPos.Mutable rootPos = new BlockPos.Mutable().func_189533_g((Vector3i)basePos).func_189534_c(Direction.UP, 1 + rand.nextInt(1));
            int rootLength = 4 + rand.nextInt(4);
            Direction rootDir = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            rootPos.func_189534_c(rootDir, 1);
            this.growRootsDownBranchingOut(world, rand, rootPos, rootLength, rootDir, 3, trunk, bb, config);
        }
        return foliage;
    }

    private void addLeafCanopy(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> trunk, List<FoliagePlacer.Foliage> foliage, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        int leafStart = 2;
        int leafTop = leafStart + 3;
        int baseMaxRange = 3;
        int addMaxRange = rand.nextInt(2);
        int maxRange = baseMaxRange + addMaxRange;
        foliage.add(new FoliagePlacer.Foliage(pos.func_177981_b(leafTop), addMaxRange, false));
        ArrayList<BlockPos> woodPositions = new ArrayList<BlockPos>();
        for (int l = 0; l <= leafStart; ++l) {
            BlockPos layerPos = pos.func_177981_b(l);
            woodPositions.add(layerPos);
            MirkOakTrunkPlacer.addLateralOffsets(woodPositions, layerPos, l + 1);
            if (l <= 0) continue;
            MirkOakTrunkPlacer.addDiagonalOffsets(woodPositions, layerPos, l);
            if (l != leafStart || addMaxRange <= 0) continue;
            MirkOakTrunkPlacer.addLateralOffsets(woodPositions, layerPos, l + 2);
            MirkOakTrunkPlacer.addDiagonalOffsets(woodPositions, layerPos, l + 1);
        }
        woodPositions.forEach(woodPos -> this.placeWood(world, rand, (BlockPos)woodPos, trunk, bb, config, Direction.Axis.Y));
    }

    private static void addLateralOffsets(List<BlockPos> list, BlockPos midPos, int offset) {
        Direction.Plane.HORIZONTAL.forEach(dir -> list.add(midPos.func_177967_a(dir, offset)));
    }

    private static void addDiagonalOffsets(List<BlockPos> list, BlockPos midPos, int offset) {
        list.add(midPos.func_177982_a(-offset, 0, -offset));
        list.add(midPos.func_177982_a(-offset, 0, offset));
        list.add(midPos.func_177982_a(offset, 0, -offset));
        list.add(midPos.func_177982_a(offset, 0, offset));
    }
}

