/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.IntPredicate;
import lotr.common.block.StrippedWoodHelper;
import lotr.common.world.gen.tree.LOTRTreeDecorators;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;

public class PineStripDecorator
extends TreeDecorator {
    public static final Codec<PineStripDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(deco -> Float.valueOf(deco.prob)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("strip_begin_height_fraction").forGetter(deco -> Float.valueOf(deco.stripBeginHeightFraction)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("strip_complete_height_fraction").forGetter(deco -> Float.valueOf(deco.stripCompleteHeightFraction))).apply((Applicative)instance, PineStripDecorator::new));
    private final float prob;
    private final float stripBeginHeightFraction;
    private final float stripCompleteHeightFraction;

    public PineStripDecorator(float f, float s0, float s1) {
        this.prob = f;
        this.stripBeginHeightFraction = s0;
        this.stripCompleteHeightFraction = s1;
    }

    protected TreeDecoratorType<?> func_230380_a_() {
        return LOTRTreeDecorators.PINE_STRIP;
    }

    public void func_225576_a_(ISeedReader world, Random rand, List<BlockPos> trunk, List<BlockPos> leaves, Set<BlockPos> decoSet, MutableBoundingBox bb) {
        if (rand.nextFloat() < this.prob) {
            int trunkBase = trunk.get(0).func_177956_o();
            int trunkHeight = trunk.size();
            int stripBeginY = Math.round((float)trunkHeight * this.stripBeginHeightFraction);
            int stripCompleteY = Math.round((float)trunkHeight * this.stripCompleteHeightFraction);
            IntPredicate stripTest = y -> {
                int yRel = y - trunkBase;
                if (yRel < stripBeginY) {
                    return false;
                }
                if (yRel >= stripCompleteY) {
                    return true;
                }
                return rand.nextFloat() < (float)(yRel - stripBeginY + 1) / (float)(stripCompleteY - stripBeginY + 1);
            };
            this.stripWood((IWorld)world, trunk, stripTest, bb);
            this.stripWood((IWorld)world, decoSet, stripTest, bb);
        }
    }

    private void stripWood(IWorld world, Collection<BlockPos> posCollection, IntPredicate stripTest, MutableBoundingBox bb) {
        HashSet temp = new HashSet();
        for (BlockPos pos : posCollection) {
            if (!stripTest.test(pos.func_177956_o())) continue;
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            Block stripped = StrippedWoodHelper.getStrippingMap().get(block);
            if (stripped == null) continue;
            EnumProperty axisProperty = RotatedPillarBlock.field_176298_M;
            BlockState strippedState = stripped.func_176223_P();
            if (strippedState.func_235901_b_((Property)axisProperty) && state.func_235901_b_((Property)axisProperty)) {
                strippedState = (BlockState)strippedState.func_206870_a((Property)axisProperty, state.func_177229_b((Property)axisProperty));
            }
            this.func_227423_a_((IWorldWriter)world, pos, strippedState, temp, bb);
        }
    }
}

