/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.Set;
import lotr.common.world.gen.tree.LOTRFoliagePlacers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;

public class ShirePineFoliagePlacer
extends FoliagePlacer {
    public static final Codec<ShirePineFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> ShirePineFoliagePlacer.func_242830_b((RecordCodecBuilder.Instance)instance).and((App)FeatureSpread.func_242254_a((int)0, (int)16, (int)8).fieldOf("foliage_height").forGetter(foliage -> foliage.heightSpread)).apply((Applicative)instance, ShirePineFoliagePlacer::new));
    private final FeatureSpread heightSpread;

    public ShirePineFoliagePlacer(FeatureSpread radius, FeatureSpread offset, FeatureSpread heightSpread) {
        super(radius, offset);
        this.heightSpread = heightSpread;
    }

    protected FoliagePlacerType<?> func_230371_a_() {
        return LOTRFoliagePlacers.SHIRE_PINE_FOLIAGE;
    }

    protected void func_230372_a_(IWorldGenerationReader world, Random rand, BaseTreeFeatureConfig config, int p_230372_4_, FoliagePlacer.Foliage foliage, int foliageHeight, int foliageMaxWidth, Set<BlockPos> leaves, int foliageOffset, MutableBoundingBox bb) {
        int layerWidth = rand.nextInt(2);
        int nextMaxLayerWidth = 1;
        int nextStartingLayerWidth = 0;
        for (int y = foliageOffset; y >= foliageOffset - foliageHeight; --y) {
            this.func_236753_a_(world, rand, config, foliage.func_236763_a_(), layerWidth, leaves, y, foliage.func_236765_c_(), bb);
            if (layerWidth >= nextMaxLayerWidth) {
                layerWidth = nextStartingLayerWidth;
                nextStartingLayerWidth = 1;
                nextMaxLayerWidth = Math.min(nextMaxLayerWidth + 1, foliageMaxWidth);
                continue;
            }
            ++layerWidth;
        }
    }

    public int func_230374_a_(Random rand, int trunkHeight, BaseTreeFeatureConfig config) {
        return this.heightSpread.func_242259_a(rand);
    }

    public int func_230376_a_(Random rand, int trunkHeight) {
        return super.func_230376_a_(rand, trunkHeight);
    }

    protected boolean func_230373_a_(Random rand, int absX, int layerY, int absZ, int layerWidth, boolean bool6) {
        return absX == layerWidth && absZ == layerWidth && layerWidth > 0;
    }
}

