/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import java.util.UUID;
import javax.annotation.Nullable;
import lotr.common.data.DataUtil;
import lotr.common.world.map.CustomWaypointStructureHandler;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.Waypoint;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractCustomWaypoint<T extends AbstractCustomWaypoint>
implements Waypoint<T> {
    public static final int MAX_NAME_LENGTH = 40;
    public static final int MAX_LORE_LENGTH = 160;
    private final UUID createdPlayer;
    private final int id;
    private String name;
    private String lore;
    private final BlockPos worldPos;
    private final double mapX;
    private final double mapZ;

    public AbstractCustomWaypoint(MapSettings map, UUID createdPlayer, int id, String name, String lore, BlockPos worldPos) {
        this.createdPlayer = createdPlayer;
        this.id = id;
        this.name = name;
        this.lore = lore;
        this.worldPos = worldPos;
        this.mapX = map.worldToMapX_frac(worldPos.func_177958_n());
        this.mapZ = map.worldToMapZ_frac(worldPos.func_177952_p());
    }

    public UUID getCreatedPlayer() {
        return this.createdPlayer;
    }

    public int getCustomId() {
        return this.id;
    }

    @Override
    public String getRawName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public ITextComponent getDisplayName() {
        return new StringTextComponent(this.name);
    }

    public String getRawLore() {
        return this.lore;
    }

    protected void setLore(String lore) {
        this.lore = lore;
    }

    @Override
    @Nullable
    public ITextComponent getDisplayLore() {
        if (!this.lore.isEmpty()) {
            return new StringTextComponent(this.lore);
        }
        return null;
    }

    @Override
    public double getMapX() {
        return this.mapX;
    }

    @Override
    public double getMapZ() {
        return this.mapZ;
    }

    @Override
    public int getWorldX() {
        return this.worldPos.func_177958_n();
    }

    @Override
    public int getWorldZ() {
        return this.worldPos.func_177952_p();
    }

    @Override
    public int getWorldYForDisplay() {
        return this.worldPos.func_177956_o();
    }

    public BlockPos getPosition() {
        return this.worldPos;
    }

    @Override
    public BlockPos getTravelPosition(ServerWorld world, PlayerEntity player) {
        return CustomWaypointStructureHandler.INSTANCE.findRandomTravelPositionForCompletedWaypoint((World)world, this, player);
    }

    @Override
    public boolean verifyFastTravellable(ServerWorld world, PlayerEntity player) {
        return CustomWaypointStructureHandler.INSTANCE.checkCompletedWaypointHasMarkerAndHandleIfNot((World)world, this, player);
    }

    @Override
    public boolean hasPlayerUnlocked(PlayerEntity player) {
        return true;
    }

    @Override
    public ITextComponent getNotUnlockedMessage(PlayerEntity player) {
        return StringTextComponent.field_240750_d_;
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    public boolean isSharedCustom() {
        return false;
    }

    @Override
    public boolean isSharedHidden() {
        return false;
    }

    @Override
    public Waypoint.WaypointDisplayState getDisplayState(PlayerEntity player) {
        return Waypoint.WaypointDisplayState.CUSTOM;
    }

    protected static <C extends AbstractCustomWaypoint> C baseLoad(MapSettings map, CompoundNBT nbt, AbstractCustomWaypointConstructor<C> constructor) {
        UUID createdPlayer = DataUtil.getUniqueIdBackCompat(nbt, "CreatedPlayer");
        int id = nbt.func_74762_e("ID");
        String name = nbt.func_74779_i("Name");
        String lore = nbt.func_74779_i("Lore");
        int posX = nbt.func_74762_e("PosX");
        int posY = nbt.func_74762_e("PosY");
        int posZ = nbt.func_74762_e("PosZ");
        BlockPos worldPos = new BlockPos(posX, posY, posZ);
        return constructor.create(map, createdPlayer, id, name, lore, worldPos);
    }

    protected void save(CompoundNBT nbt) {
        nbt.func_186854_a("CreatedPlayer", this.createdPlayer);
        nbt.func_74768_a("ID", this.id);
        nbt.func_74778_a("Name", this.name);
        nbt.func_74778_a("Lore", this.lore);
        nbt.func_74768_a("PosX", this.worldPos.func_177958_n());
        nbt.func_74768_a("PosY", this.worldPos.func_177956_o());
        nbt.func_74768_a("PosZ", this.worldPos.func_177952_p());
    }

    protected static <C extends AbstractCustomWaypoint> C baseRead(MapSettings map, PacketBuffer buf, AbstractCustomWaypointConstructor<C> constructor) {
        UUID createdPlayer = buf.func_179253_g();
        int id = buf.func_150792_a();
        String name = buf.func_218666_n();
        String lore = buf.func_218666_n();
        BlockPos worldPos = buf.func_179259_c();
        return constructor.create(map, createdPlayer, id, name, lore, worldPos);
    }

    protected void write(PacketBuffer buf) {
        buf.func_179252_a(this.createdPlayer);
        buf.func_150787_b(this.id);
        buf.func_180714_a(this.name);
        buf.func_180714_a(this.lore);
        buf.func_179255_a(this.worldPos);
    }

    protected abstract void removeFromPlayerData(PlayerEntity var1);

    @FunctionalInterface
    protected static interface AbstractCustomWaypointConstructor<C extends AbstractCustomWaypoint> {
        public C create(MapSettings var1, UUID var2, int var3, String var4, String var5, BlockPos var6);
    }
}

