/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

public enum MapMarkerIcon {
    CROSS("cross", 0, 236),
    PICKAXE("pickaxe", 10, 236),
    SWORD("sword", 20, 236),
    CIRCLE("circle", 30, 236),
    EXCLAMATION("exclamation", 40, 236),
    QUESTION("question", 50, 236),
    STAR("star", 60, 236),
    ARROW("arrow", 70, 236),
    EYE("eye", 80, 236),
    TREE("tree", 90, 236),
    SNAKE("snake", 100, 236),
    MOUNTAIN("mountain", 110, 236),
    ANVIL("anvil", 120, 236),
    TOWER("tower", 130, 236),
    SHIP("ship", 140, 236),
    SKULL("skull", 150, 236),
    SACK("sack", 160, 236),
    CHEST("chest", 170, 236);

    public final String name;
    public final int networkId;
    private final int iconU;
    private final int iconV;

    private MapMarkerIcon(String name, int u, int v) {
        this.name = name;
        this.networkId = this.ordinal();
        this.iconU = u;
        this.iconV = v;
    }

    public int getU(boolean highlight) {
        return this.iconU;
    }

    public int getV(boolean highlight) {
        return this.iconV + (highlight ? 10 : 0);
    }

    public static MapMarkerIcon forNameOrDefault(String name) {
        for (MapMarkerIcon icon : MapMarkerIcon.values()) {
            if (!icon.name.equals(name)) continue;
            return icon;
        }
        return CROSS;
    }

    public static MapMarkerIcon forNetworkIdOrDefault(int id) {
        for (MapMarkerIcon icon : MapMarkerIcon.values()) {
            if (icon.networkId != id) continue;
            return icon;
        }
        return CROSS;
    }
}

