/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import lotr.common.LOTRLog;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionSettingsManager;
import lotr.common.util.LOTRUtil;
import lotr.common.util.LazyReference;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.Waypoint;
import lotr.common.world.map.WaypointNetworkType;
import lotr.common.world.map.WaypointRegion;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MapWaypoint
implements Waypoint<MapWaypoint> {
    private final MapSettings mapSettings;
    private final ResourceLocation resourceName;
    private final int assignedId;
    private final String name;
    private final boolean translateName;
    private final String lore;
    private final boolean translateLore;
    private final double mapX;
    private final double mapZ;
    private final int worldX;
    private final int worldZ;
    private final WaypointRegion region;
    private final LazyReference<Faction> travelFaction;

    public MapWaypoint(MapSettings map, ResourceLocation res, int id, String name, boolean translateName, String lore, boolean translateLore, double x, double z, WaypointRegion region, ResourceLocation facName) {
        this.mapSettings = map;
        this.resourceName = res;
        this.assignedId = id;
        this.name = name;
        this.translateName = translateName;
        this.lore = lore;
        this.translateLore = translateLore;
        this.mapX = x;
        this.mapZ = z;
        this.worldX = map.mapToWorldX(this.mapX);
        this.worldZ = map.mapToWorldZ(this.mapZ);
        this.region = region;
        this.travelFaction = facName == null ? null : LazyReference.of(facName, ref -> FactionSettingsManager.sidedInstance(map.getSide()).getCurrentLoadedFactions().getFactionByName((ResourceLocation)ref), unresolvedRef -> LOTRLog.warn("Cannot resolve faction name %s in map waypoint %s - ensure the JSON file is correct", unresolvedRef, this.resourceName));
    }

    public static MapWaypoint read(MapSettings map, ResourceLocation resourceName, JsonObject json, int assignedId) {
        String facName;
        if (json.size() == 0) {
            LOTRLog.info("Map waypoint %s has an empty file - not loading it in this world", resourceName);
            return null;
        }
        JsonObject nameObj = json.get("name").getAsJsonObject();
        String name = nameObj.get("text").getAsString();
        boolean translateName = nameObj.get("translate").getAsBoolean();
        JsonObject loreObj = json.get("lore").getAsJsonObject();
        String lore = loreObj.get("text").getAsString();
        boolean translateLore = loreObj.get("translate").getAsBoolean();
        double mapX = json.get("x").getAsDouble() + 0.5;
        double mapZ = json.get("z").getAsDouble() + 0.5;
        String regionName = json.get("travel_region").getAsString();
        WaypointRegion region = map.getWaypointRegionByName(new ResourceLocation(regionName));
        if (region == null) {
            LOTRLog.warn("Map waypoint %s declares unknown region name %s - no such waypoint region exists in this map", resourceName, regionName);
            return null;
        }
        ResourceLocation factionReference = null;
        if (json.has("faction") && !(facName = json.get("faction").getAsString()).isEmpty()) {
            factionReference = new ResourceLocation(facName);
        }
        return new MapWaypoint(map, resourceName, assignedId, name, translateName, lore, translateLore, mapX, mapZ, region, factionReference);
    }

    public static MapWaypoint read(MapSettings map, PacketBuffer buf) {
        boolean hasFaction;
        ResourceLocation resourceName = buf.func_192575_l();
        int assignedID = buf.func_150792_a();
        String name = buf.func_218666_n();
        boolean translateName = buf.readBoolean();
        String lore = buf.func_218666_n();
        boolean translateLore = buf.readBoolean();
        double mapX = buf.readDouble();
        double mapZ = buf.readDouble();
        int regionId = buf.func_150792_a();
        WaypointRegion region = map.getWaypointRegionByID(regionId);
        if (region == null) {
            LOTRLog.warn("Received waypoint %s from server with a nonexistent waypoint region ID (%d)", resourceName, regionId);
        }
        ResourceLocation factionReference = (hasFaction = buf.readBoolean()) ? buf.func_192575_l() : null;
        return new MapWaypoint(map, resourceName, assignedID, name, translateName, lore, translateLore, mapX, mapZ, region, factionReference);
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.resourceName);
        buf.func_150787_b(this.assignedId);
        buf.func_180714_a(this.name);
        buf.writeBoolean(this.translateName);
        buf.func_180714_a(this.lore);
        buf.writeBoolean(this.translateLore);
        buf.writeDouble(this.mapX);
        buf.writeDouble(this.mapZ);
        buf.func_150787_b(this.region.getAssignedId());
        boolean hasFaction = this.travelFaction != null;
        buf.writeBoolean(hasFaction);
        if (hasFaction) {
            buf.func_192572_a(this.travelFaction.getReferenceName());
        }
    }

    public ResourceLocation getName() {
        return this.resourceName;
    }

    @Override
    public String getRawName() {
        return this.resourceName.toString();
    }

    public int getAssignedId() {
        return this.assignedId;
    }

    @Override
    public ITextComponent getDisplayName() {
        if (this.translateName) {
            return new TranslationTextComponent(this.name);
        }
        return new StringTextComponent(this.name);
    }

    @Override
    public ITextComponent getDisplayLore() {
        if (this.translateLore) {
            return new TranslationTextComponent(this.lore);
        }
        return new StringTextComponent(this.lore);
    }

    @Override
    @Nullable
    public ITextComponent getDisplayOwnership() {
        return null;
    }

    @Override
    public double getMapX() {
        return this.mapX;
    }

    @Override
    public double getMapZ() {
        return this.mapZ;
    }

    @Override
    public int getWorldX() {
        return this.worldX;
    }

    @Override
    public int getWorldZ() {
        return this.worldZ;
    }

    @Override
    public int getWorldYForDisplay() {
        return -1;
    }

    @Override
    @Nullable
    public BlockPos getTravelPosition(ServerWorld world, PlayerEntity player) {
        int worldY = LOTRUtil.forceLoadChunkAndGetTopBlock((World)world, this.worldX, this.worldZ);
        return new BlockPos(this.worldX, worldY, this.worldZ);
    }

    public WaypointRegion getTravelRegion() {
        return this.region;
    }

    @Override
    public boolean hasPlayerUnlocked(PlayerEntity player) {
        LOTRLevelData levelData = LOTRLevelData.sidedInstance((IWorldReader)player.field_70170_p);
        LOTRPlayerData pd = levelData.getData(player);
        return pd.getFastTravelData().isWaypointRegionUnlocked(this.region) && this.isCompatibleAlignment(player);
    }

    @Override
    public ITextComponent getNotUnlockedMessage(PlayerEntity player) {
        if (!this.isCompatibleAlignment(player)) {
            return new TranslationTextComponent("gui.lotr.map.locked.enemy");
        }
        return new TranslationTextComponent("gui.lotr.map.locked.region");
    }

    private boolean isCompatibleAlignment(PlayerEntity player) {
        Faction fac = this.getTravelFaction();
        if (fac != null) {
            LOTRPlayerData pd = LOTRLevelData.sidedInstance((IWorldReader)player.field_70170_p).getData(player);
            return pd.getAlignmentData().getAlignment(fac) >= 0.0f;
        }
        return true;
    }

    private Faction getTravelFaction() {
        return this.travelFaction != null ? this.travelFaction.resolveReference() : null;
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public boolean isSharedCustom() {
        return false;
    }

    @Override
    public boolean isSharedHidden() {
        return false;
    }

    @Override
    public Waypoint.WaypointDisplayState getDisplayState(@Nullable PlayerEntity player) {
        if (player == null) {
            return Waypoint.WaypointDisplayState.STANDARD;
        }
        if (this.hasPlayerUnlocked(player)) {
            return Waypoint.WaypointDisplayState.STANDARD;
        }
        if (!this.isCompatibleAlignment(player)) {
            return Waypoint.WaypointDisplayState.STANDARD_LOCKED_TO_ENEMIES;
        }
        return Waypoint.WaypointDisplayState.STANDARD_LOCKED;
    }

    @Override
    public WaypointNetworkType<MapWaypoint> getType() {
        return WaypointNetworkType.MAP;
    }

    public static void writeIdentification(PacketBuffer buf, MapWaypoint wp) {
        buf.func_150787_b(wp.assignedId);
    }

    public static MapWaypoint readFromIdentification(PacketBuffer buf, LOTRPlayerData pd) {
        int wpId;
        MapSettings map = MapSettingsManager.sidedInstance(pd.getLogicalSide()).getCurrentLoadedMap();
        MapWaypoint wp = map.getWaypointByID(wpId = buf.func_150792_a());
        if (wp == null) {
            LOTRLog.warn("Received nonexistent map waypoint ID %d from %s", wpId, pd.getLogicalSide());
        }
        return wp;
    }
}

