/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import com.google.common.math.IntMath;
import java.util.Random;
import java.util.function.UnaryOperator;
import lotr.common.world.biome.LOTRBiomeWrapper;
import lotr.common.world.gen.feature.LOTRFeatures;
import lotr.common.world.map.BridgeBlockProvider;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.RoadBlockProvider;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;

public class RoadGenerator {
    public static final int ROAD_DEPTH = 4;

    public boolean generateRoad(IWorld world, IChunk chunk, Random rand, LOTRBiomeWrapper biomeWrapper, BlockPos topPos, int seaLevel) {
        MapSettings mapSettings = MapSettingsManager.sidedInstance((IWorldReader)world).getCurrentLoadedMap();
        RoadBlockProvider roadProvider = biomeWrapper.getRoadBlockProvider();
        BridgeBlockProvider bridgeProvider = biomeWrapper.getBridgeBlockProvider();
        int x = topPos.func_177958_n();
        int z = topPos.func_177952_p();
        if (mapSettings.getRoadPointCache().isRoadAt(x, z)) {
            int roadTop = 0;
            int bridgeBase = 0;
            boolean bridge = false;
            boolean bridgeSlab = false;
            BlockState topState = chunk.func_180495_p(topPos);
            if (topState.func_200015_d((IBlockReader)chunk, topPos)) {
                bridge = false;
                roadTop = topPos.func_177956_o();
            } else if (topState.func_185904_a().func_76224_d()) {
                bridgeBase = roadTop = topPos.func_177956_o() + 1;
                int maxBridgeTop = topPos.func_177956_o() + 6;
                float bridgeHeight = 0.0f;
                BlockPos.Mutable belowBridgePos = new BlockPos.Mutable().func_189533_g((Vector3i)topPos);
                while (belowBridgePos.func_177956_o() > 0) {
                    belowBridgePos.func_189536_c(Direction.DOWN);
                    BlockState belowState = chunk.func_180495_p((BlockPos)belowBridgePos);
                    if (!belowState.func_185904_a().func_76224_d()) break;
                    bridgeHeight += 0.5f;
                }
                int bridgeHeightInt = (int)Math.floor(bridgeHeight);
                roadTop += bridgeHeightInt;
                if ((roadTop = Math.min(roadTop, maxBridgeTop)) >= maxBridgeTop) {
                    bridgeSlab = true;
                } else {
                    float bridgeHeightR = bridgeHeight - (float)bridgeHeightInt;
                    if (bridgeHeightR < 0.5f) {
                        bridgeSlab = true;
                    }
                }
                bridge = true;
            }
            if (bridge) {
                boolean fence = this.isFenceAt(mapSettings, x, z);
                if (fence) {
                    boolean pillar = this.isPillarAt(mapSettings, x, z);
                    if (pillar) {
                        BlockState block;
                        int pillarTop = roadTop + 4;
                        BlockPos.Mutable pillarPos = new BlockPos.Mutable(x, pillarTop, z);
                        while (pillarPos.func_177956_o() > 0 && !(block = chunk.func_180495_p((BlockPos)pillarPos)).func_200015_d((IBlockReader)chunk, (BlockPos)pillarPos)) {
                            if (pillarPos.func_177956_o() >= pillarTop) {
                                this.setBlock(chunk, (BlockPos)pillarPos, bridgeProvider.getFenceBlock(rand, (BlockPos)pillarPos));
                            } else if (pillarPos.func_177956_o() >= pillarTop - 1) {
                                this.setBlock(chunk, (BlockPos)pillarPos, bridgeProvider.getMainBlock(rand, (BlockPos)pillarPos));
                            } else {
                                this.setBlockAndUpdateAdjacent(chunk, world, (BlockPos)pillarPos, bridgeProvider.getBeamBlock(rand, (BlockPos)pillarPos));
                            }
                            pillarPos.func_189536_c(Direction.DOWN);
                        }
                    } else {
                        int ySupport;
                        BlockPos.Mutable edgePos = new BlockPos.Mutable(x, roadTop, z);
                        this.setBlock(chunk, (BlockPos)edgePos, bridgeProvider.getBeamBlock(rand, (BlockPos)edgePos));
                        edgePos.func_189536_c(Direction.UP);
                        this.setBlockAndUpdateAdjacent(chunk, world, (BlockPos)edgePos, bridgeProvider.getFenceBlock(rand, (BlockPos)edgePos));
                        if (roadTop > bridgeBase) {
                            edgePos.func_185336_p(roadTop - 1);
                            this.setBlockAndUpdateAdjacent(chunk, world, (BlockPos)edgePos, bridgeProvider.getBeamBlock(rand, (BlockPos)edgePos));
                        }
                        if (roadTop - 1 > (ySupport = bridgeBase + 2)) {
                            edgePos.func_185336_p(ySupport);
                            this.setBlockAndUpdateAdjacent(chunk, world, (BlockPos)edgePos, bridgeProvider.getFenceBlock(rand, (BlockPos)edgePos));
                        }
                    }
                } else {
                    BlockPos.Mutable bridgePos = new BlockPos.Mutable(x, roadTop, z);
                    if (bridgeSlab) {
                        this.setBlock(chunk, (BlockPos)bridgePos, bridgeProvider.getMainSlabBlock(rand, (BlockPos)bridgePos));
                    } else {
                        this.setBlock(chunk, (BlockPos)bridgePos, bridgeProvider.getMainBlock(rand, (BlockPos)bridgePos));
                    }
                    if (roadTop > bridgeBase) {
                        bridgePos.func_189536_c(Direction.DOWN);
                        this.setBlock(chunk, (BlockPos)bridgePos, bridgeProvider.getMainBlock(rand, (BlockPos)bridgePos));
                    }
                }
            } else {
                float repair = roadProvider.getRepair();
                boolean isEdge = this.isRoadEdge(mapSettings, x, z);
                boolean isHedge = roadProvider.hasHedge() && isEdge;
                BlockPos.Mutable roadPos = new BlockPos.Mutable(x, roadTop, z);
                if (isHedge) {
                    roadPos.func_189536_c(Direction.UP);
                    if (rand.nextFloat() < roadProvider.getHedgeDensity()) {
                        BlockState hedgeBlock = roadProvider.getHedgeBlock(rand, (BlockPos)roadPos);
                        this.setBlock(chunk, (BlockPos)roadPos, hedgeBlock);
                        this.setGrassToDirtBelowIfPlacedBlockSolid(chunk, (BlockPos)roadPos, hedgeBlock);
                    }
                } else {
                    boolean isDistinctEdge = roadProvider.hasDistinctEdge() && isEdge;
                    boolean elevatedEdge = isDistinctEdge && rand.nextFloat() < repair;
                    boolean isTop = true;
                    while (roadPos.func_177956_o() > roadTop - 4 && roadPos.func_177956_o() > 0) {
                        float repairHere = repair;
                        if (isDistinctEdge && isTop) {
                            repairHere *= repair;
                        }
                        if (rand.nextFloat() < repairHere) {
                            BlockState roadBlockState;
                            RoadBlockProvider roadToUse;
                            boolean isSlab = false;
                            if (isTop && roadPos.func_177956_o() >= seaLevel + 1) {
                                isSlab = this.determineIsSlab(chunk, roadPos);
                            }
                            if (isTop && elevatedEdge) {
                                UnaryOperator moveUpByHalfBlock = inputIsSlab -> {
                                    if (inputIsSlab.booleanValue()) {
                                        inputIsSlab = false;
                                    } else {
                                        inputIsSlab = true;
                                        roadPos.func_189536_c(Direction.UP);
                                    }
                                    return inputIsSlab;
                                };
                                isSlab = (Boolean)moveUpByHalfBlock.apply(isSlab);
                                if (rand.nextInt(18) == 0) {
                                    isSlab = (Boolean)moveUpByHalfBlock.apply(isSlab);
                                }
                            }
                            RoadBlockProvider roadBlockProvider = roadToUse = isDistinctEdge ? roadProvider.getEdgeProvider() : roadProvider;
                            BlockState blockState = isSlab ? roadToUse.getTopSlabBlock(rand, (BlockPos)roadPos) : (roadBlockState = isTop ? roadToUse.getTopBlock(rand, (BlockPos)roadPos) : roadToUse.getFillerBlock(rand, (BlockPos)roadPos));
                            if (roadToUse.requiresPostProcessing()) {
                                this.setBlockAndUpdateAdjacent(chunk, world, (BlockPos)roadPos, roadBlockState);
                            } else {
                                this.setBlock(chunk, (BlockPos)roadPos, roadBlockState);
                            }
                            if (roadPos.func_177956_o() > roadTop) {
                                this.setGrassToDirtBelowIfPlacedBlockSolid(chunk, (BlockPos)roadPos, roadBlockState);
                            }
                        }
                        roadPos.func_189536_c(Direction.DOWN);
                        isTop = false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean determineIsSlab(IChunk chunk, BlockPos.Mutable roadPos) {
        ChunkPos pos = chunk.func_76632_l();
        int chunkXStart = pos.func_180334_c();
        int chunkXEnd = pos.func_180332_e();
        int chunkZStart = pos.func_180333_d();
        int chunkZEnd = pos.func_180330_f();
        int x = roadPos.func_177958_n();
        int z = roadPos.func_177952_p();
        int y = roadPos.func_177956_o();
        int totalChecked = 0;
        int nearbySolid = 0;
        BlockPos.Mutable checkPos = new BlockPos.Mutable();
        for (int checkX = x - 1; checkX <= x + 1; ++checkX) {
            for (int checkZ = z - 1; checkZ <= z + 1; ++checkZ) {
                if (checkX == x && checkZ == z || checkX < chunkXStart || checkX > chunkXEnd || checkZ < chunkZStart || checkZ > chunkZEnd) continue;
                checkPos.func_181079_c(checkX, y, checkZ);
                BlockState checkState = chunk.func_180495_p((BlockPos)checkPos);
                if (checkState.func_200015_d((IBlockReader)chunk, (BlockPos)checkPos) || checkState.func_177230_c() instanceof SlabBlock) {
                    ++nearbySolid;
                }
                ++totalChecked;
            }
        }
        if (totalChecked == 0) {
            return false;
        }
        float avgSolid = (float)nearbySolid / (float)totalChecked;
        return (double)avgSolid < 1.0;
    }

    private void setBlock(IChunk chunk, BlockPos pos, BlockState state) {
        chunk.func_177436_a(pos, state, false);
    }

    private void setBlockAndUpdateAdjacent(IChunk chunk, IWorld world, BlockPos pos, BlockState state) {
        this.setBlock(chunk, pos, state);
        chunk.func_201594_d(pos);
    }

    private void setGrassToDirtBelowIfPlacedBlockSolid(IChunk chunk, BlockPos pos, BlockState placedState) {
        if (placedState.func_224755_d((IBlockReader)chunk, pos, Direction.DOWN)) {
            LOTRFeatures.setGrassToDirtBelowDuringChunkGen(chunk, pos);
        }
    }

    private boolean isRoadEdge(MapSettings mapSettings, int i, int k) {
        for (int i1 = -1; i1 <= 1; ++i1) {
            for (int k1 = -1; k1 <= 1; ++k1) {
                if (i1 == 0 && k1 == 0 || mapSettings.getRoadPointCache().isRoadAt(i + i1, k + k1)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFenceAt(MapSettings mapSettings, int i, int k) {
        return this.isRoadEdge(mapSettings, i, k);
    }

    private boolean isPillarAt(MapSettings mapSettings, int i, int k) {
        int zmod;
        int pRange = 8;
        int xmod = IntMath.mod((int)i, (int)pRange);
        if (IntMath.mod((int)(xmod + (zmod = IntMath.mod((int)k, (int)pRange))), (int)pRange) == 0) {
            return !this.isBridgeEdgePillar(mapSettings, i + 1, k - 1) && !this.isBridgeEdgePillar(mapSettings, i + 1, k + 1);
        }
        return false;
    }

    private boolean isBridgeEdgePillar(MapSettings mapSettings, int i, int k) {
        return mapSettings.getRoadPointCache().isRoadAt(i, k) && this.isFenceAt(mapSettings, i, k) && this.isPillarAt(mapSettings, i, k);
    }
}

