/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import lotr.common.LOTRLog;
import lotr.common.data.DataUtil;
import lotr.common.world.map.MapSettings;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class WaypointRegion {
    private final ResourceLocation resourceName;
    private final int assignedId;
    private final List<ResourceLocation> biomeNames;

    private WaypointRegion(ResourceLocation resourceName, int assignedId, List<ResourceLocation> biomeNames) {
        this.resourceName = resourceName;
        this.assignedId = assignedId;
        this.biomeNames = biomeNames;
    }

    public static WaypointRegion readCombined(MapSettings map, ResourceLocation resourceName, List<JsonObject> jsonVersions, int assignedId) {
        ArrayList<ResourceLocation> biomeNames = new ArrayList<ResourceLocation>();
        for (JsonObject json : jsonVersions) {
            boolean replacePrevious = json.get("replace").getAsBoolean();
            if (replacePrevious) {
                biomeNames.clear();
            }
            JsonArray biomeArray = json.get("biomes").getAsJsonArray();
            for (JsonElement elem : biomeArray) {
                ResourceLocation biomeName = new ResourceLocation(elem.getAsString());
                biomeNames.add(biomeName);
            }
        }
        if (biomeNames.isEmpty()) {
            LOTRLog.warn("Waypoint region %s does not declare any biomes", resourceName);
        }
        return new WaypointRegion(resourceName, assignedId, biomeNames);
    }

    public static WaypointRegion read(PacketBuffer buf) {
        ResourceLocation resourceName = buf.func_192575_l();
        int assignedID = buf.func_150792_a();
        ArrayList<ResourceLocation> biomeNames = new ArrayList<ResourceLocation>();
        DataUtil.fillCollectionFromBuffer(buf, biomeNames, () -> ((PacketBuffer)buf).func_192575_l());
        return new WaypointRegion(resourceName, assignedID, biomeNames);
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.resourceName);
        buf.func_150787_b(this.assignedId);
        DataUtil.writeCollectionToBuffer(buf, this.biomeNames, arg_0 -> ((PacketBuffer)buf).func_192572_a(arg_0));
    }

    public ResourceLocation getName() {
        return this.resourceName;
    }

    public int getAssignedId() {
        return this.assignedId;
    }

    public List<ResourceLocation> getBiomeNames() {
        return this.biomeNames;
    }
}

