/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import com.google.gson.JsonObject;
import java.util.Random;
import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.data.NPCEntitySettingsManager;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;

public class NPCSpawnEntry<E extends NPCEntity>
extends WeightedRandom.Item {
    private final Supplier<EntityType<E>> type;
    private final int minCount;
    private final int maxCount;

    private NPCSpawnEntry(Supplier<EntityType<E>> type, int weight, int min, int max) {
        super(weight);
        this.type = type;
        this.minCount = min;
        this.maxCount = max;
    }

    public static NPCSpawnEntry read(ResourceLocation resourceName, JsonObject json) {
        String typeName = json.get("entity_type").getAsString();
        ResourceLocation typeNameRes = new ResourceLocation(typeName);
        EntityType<?> entityType = NPCEntitySettingsManager.lookupEntityTypeByName(typeNameRes);
        if (entityType == null) {
            LOTRLog.warn("Failed to load NPC spawn entry in list %s - nonexistent entity type %s", resourceName, typeName);
            return null;
        }
        int weight = json.get("weight").getAsInt();
        int minCount = json.get("min_count").getAsInt();
        int maxCount = json.get("max_count").getAsInt();
        return new NPCSpawnEntry(() -> entityType, weight, minCount, maxCount);
    }

    public EntityType<E> getType() {
        return this.type.get();
    }

    public int getRandomGroupSize(Random rand) {
        return MathHelper.func_76136_a((Random)rand, (int)this.minCount, (int)this.maxCount);
    }

    public static class EntryInContext {
        public final NPCSpawnEntry spawnEntry;
        public final boolean isConquestSpawn;

        public EntryInContext(NPCSpawnEntry entry, boolean conquest) {
            this.spawnEntry = entry;
            this.isConquestSpawn = conquest;
        }
    }
}

