/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.common.world.spawning.NPCSpawnEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;

public class NPCSpawnList {
    private final List<NPCSpawnEntry> entries;
    private final ResourceLocation resourceName;

    private NPCSpawnList(ResourceLocation resourceName, List<NPCSpawnEntry> entries) {
        this.resourceName = resourceName;
        this.entries = entries;
    }

    public static NPCSpawnList read(ResourceLocation resourceName, JsonObject json) {
        JsonArray entryArray = json.get("entries").getAsJsonArray();
        ArrayList<NPCSpawnEntry> entries = new ArrayList<NPCSpawnEntry>();
        for (JsonElement elem : entryArray) {
            NPCSpawnEntry entry = NPCSpawnEntry.read(resourceName, elem.getAsJsonObject());
            if (entry == null) continue;
            entries.add(entry);
        }
        return new NPCSpawnList(resourceName, entries);
    }

    public ResourceLocation getName() {
        return this.resourceName;
    }

    public List<NPCSpawnEntry> getReadOnlyList() {
        return new ArrayList<NPCSpawnEntry>(this.entries);
    }

    public NPCSpawnEntry getRandomSpawnEntry(Random rand) {
        return (NPCSpawnEntry)WeightedRandom.func_76271_a((Random)rand, this.entries);
    }
}

