/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lotr.common.world.spawning.BiomeNPCSpawnList;
import lotr.common.world.spawning.NPCSpawnList;
import net.minecraft.util.ResourceLocation;

public class NPCSpawnSettings {
    private final List<NPCSpawnList> spawnLists;
    private final Map<ResourceLocation, NPCSpawnList> spawnListsByName;
    private Map<ResourceLocation, BiomeNPCSpawnList> biomeSpawnLists;

    public NPCSpawnSettings(List<NPCSpawnList> spawnLists) {
        this.spawnLists = spawnLists;
        this.spawnListsByName = spawnLists.stream().collect(Collectors.toMap(NPCSpawnList::getName, UnaryOperator.identity()));
    }

    public List<NPCSpawnList> getSpawnLists() {
        return this.spawnLists;
    }

    public NPCSpawnList getSpawnListByName(ResourceLocation name) {
        return this.spawnListsByName.get(name);
    }

    public Map<ResourceLocation, BiomeNPCSpawnList> getBiomeSpawnLists() {
        return this.biomeSpawnLists;
    }

    public void setBiomeSpawnLists(Map<ResourceLocation, BiomeNPCSpawnList> spawns) {
        if (this.biomeSpawnLists != null) {
            throw new IllegalArgumentException("Cannot set biomeSpawnLists - already set!");
        }
        this.biomeSpawnLists = spawns;
    }

    public BiomeNPCSpawnList getSpawnsForBiomeOrFallbackEmpty(ResourceLocation biomeName) {
        return this.biomeSpawnLists.computeIfAbsent(biomeName, BiomeNPCSpawnList::createDefaultEmptyList);
    }
}

