/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lotr.common.LOTRLog;
import lotr.common.fac.FactionSettings;
import lotr.common.fac.FactionSettingsManager;
import lotr.common.init.LOTRBiomes;
import lotr.common.resources.InstancedJsonReloadListener;
import lotr.common.world.spawning.BiomeNPCSpawnList;
import lotr.common.world.spawning.NPCSpawnList;
import lotr.common.world.spawning.NPCSpawnSettings;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.LogicalSide;

public class NPCSpawnSettingsManager
extends InstancedJsonReloadListener {
    private static final String SPAWNS_FOLDER = "npcs/biome_npc_spawns";
    private static final String LISTS_SUBFOLDER = "lists/";
    public static final NPCSpawnSettingsManager INSTANCE = new NPCSpawnSettingsManager();
    private NPCSpawnSettings currentLoadedSpawns;

    private NPCSpawnSettingsManager() {
        super(SPAWNS_FOLDER, "NPCSpawnSettings", LogicalSide.SERVER);
    }

    private NPCSpawnSettings loadSpawnsFromJsons(IResourceManager resMgr, FactionSettings factionSettings, Map<ResourceLocation, JsonObject> listJsons, Map<ResourceLocation, JsonObject> biomeJsons) {
        ArrayList<NPCSpawnList> spawnLists = new ArrayList<NPCSpawnList>();
        for (Map.Entry<ResourceLocation, JsonObject> entry : listJsons.entrySet()) {
            ResourceLocation res = entry.getKey();
            ResourceLocation resourceLocation = NPCSpawnSettingsManager.trimSubFolderResource(res, LISTS_SUBFOLDER);
            JsonObject spawnListJson = entry.getValue();
            try {
                NPCSpawnList spawnList = NPCSpawnList.read(resourceLocation, spawnListJson);
                if (spawnList == null) continue;
                spawnLists.add(spawnList);
            }
            catch (Exception e) {
                LOTRLog.warn("Failed to load NPC spawn list %s from file", resourceLocation);
                e.printStackTrace();
            }
        }
        NPCSpawnSettings spawnSettings = new NPCSpawnSettings(spawnLists);
        HashMap<ResourceLocation, BiomeNPCSpawnList.PreLoaded> biomeSpawnListsPre = new HashMap<ResourceLocation, BiomeNPCSpawnList.PreLoaded>();
        for (Map.Entry entry : biomeJsons.entrySet()) {
            ResourceLocation biomeName = (ResourceLocation)entry.getKey();
            JsonObject biomeSpawnListJson = (JsonObject)entry.getValue();
            try {
                BiomeNPCSpawnList.PreLoaded biomeSpawnList = BiomeNPCSpawnList.PreLoaded.read(spawnSettings, factionSettings, biomeName, biomeSpawnListJson);
                if (biomeSpawnList == null) continue;
                biomeSpawnListsPre.put(biomeName, biomeSpawnList);
            }
            catch (Exception e) {
                LOTRLog.warn("Failed to load biome NPC spawn list for %s from file", biomeName);
                e.printStackTrace();
            }
        }
        HashMap<ResourceLocation, BiomeNPCSpawnList> biomeSpawnLists = new HashMap<ResourceLocation, BiomeNPCSpawnList>();
        for (Map.Entry e : biomeSpawnListsPre.entrySet()) {
            ResourceLocation biomeName = (ResourceLocation)e.getKey();
            BiomeNPCSpawnList fullyLoaded = ((BiomeNPCSpawnList.PreLoaded)e.getValue()).resolveParentAndFinaliseAfterLoad(biomeSpawnListsPre);
            if (fullyLoaded == null) continue;
            biomeSpawnLists.put(biomeName, fullyLoaded);
        }
        spawnSettings.setBiomeSpawnLists(biomeSpawnLists);
        return spawnSettings;
    }

    public NPCSpawnSettings getCurrentLoadedSpawns() {
        return this.currentLoadedSpawns;
    }

    public static BiomeNPCSpawnList getSpawnsForBiome(Biome biome, IWorld world) {
        return INSTANCE.getCurrentLoadedSpawns().getSpawnsForBiomeOrFallbackEmpty(LOTRBiomes.getBiomeRegistryName(biome, world));
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, IResourceManager serverResMgr, IProfiler profiler) {
        Map<ResourceLocation, JsonObject> listJsons = this.filterDataJsonsBySubFolder(jsons, LISTS_SUBFOLDER);
        Map<ResourceLocation, JsonObject> biomeJsons = this.filterDataJsonsByRootFolderOnly(jsons);
        FactionSettings factionSettings = FactionSettingsManager.serverInstance().getCurrentLoadedFactions();
        this.currentLoadedSpawns = this.loadSpawnsFromJsons(serverResMgr, factionSettings, listJsons, biomeJsons);
        this.logSpawnsLoad("Loaded serverside NPC spawn settings", this.currentLoadedSpawns);
    }

    private void logSpawnsLoad(String prefix, NPCSpawnSettings spawns) {
        LOTRLog.info("%s - %d spawn lists, %d biome spawn tables", prefix, spawns.getSpawnLists().size(), spawns.getBiomeSpawnLists().size());
    }
}

