/*
 * Decompiled with CFR 0.152.
 */
package lotr.curuquesta;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import lotr.curuquesta.ReplaceableSpeechVariable;
import lotr.curuquesta.SpeechbankContext;
import lotr.curuquesta.SpeechbankEntry;

public class Speechbank {
    private final String speechbankName;
    private final List<SpeechbankEntry> entries;

    public Speechbank(String speechbankName, List<SpeechbankEntry> entries) {
        this.speechbankName = speechbankName;
        this.entries = entries;
    }

    public String getRandomSpeech(SpeechbankContext context, Random rand) {
        List<String> matchingLines = this.filterMatchingLines(context);
        if (matchingLines.isEmpty()) {
            return String.format("Speechbank %s found no lines matching the current context!", this.speechbankName);
        }
        String line = matchingLines.get(rand.nextInt(matchingLines.size()));
        line = this.fillAllVariablesInLine(line, context);
        return line;
    }

    private List<String> filterMatchingLines(SpeechbankContext context) {
        return this.entries.stream().filter(e -> e.doesContextMeetConditions(context)).flatMap(SpeechbankEntry::streamLines).collect(Collectors.toList());
    }

    private String fillAllVariablesInLine(String line, SpeechbankContext context) {
        for (Map.Entry<ReplaceableSpeechVariable, String> e : context.getReplaceVariableValues()) {
            ReplaceableSpeechVariable variable = e.getKey();
            String value = e.getValue();
            line = variable.fillMatchesInSpeechLine(line, value);
        }
        return line;
    }
}

