/*
 * Decompiled with CFR 0.152.
 */
package lotr.curuquesta;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lotr.curuquesta.ReplaceableSpeechVariable;
import lotr.curuquesta.SpeechbankCondition;

public class SpeechbankContext {
    private Map<SpeechbankCondition<?>, Object> conditionValues = new HashMap();
    private Map<ReplaceableSpeechVariable, String> replaceVariableValues = new HashMap<ReplaceableSpeechVariable, String>();

    private SpeechbankContext() {
    }

    public static SpeechbankContext newContext() {
        return new SpeechbankContext();
    }

    public SpeechbankContext withCondition(SpeechbankCondition<?> condition, Object value) {
        if (this.conditionValues.containsKey(condition)) {
            throw new IllegalStateException("Speechbank context already has a value set for condition " + condition);
        }
        if (value == null) {
            throw new IllegalArgumentException("Speechbank condition value cannot be null");
        }
        this.conditionValues.put(condition, value);
        return this;
    }

    public SpeechbankContext withReplaceableVariable(ReplaceableSpeechVariable variable, String value) {
        if (this.replaceVariableValues.containsKey(variable)) {
            throw new IllegalStateException("Speechbank context already has a value set for variable " + variable);
        }
        this.replaceVariableValues.put(variable, value);
        return this;
    }

    public <T> T getConditionValue(SpeechbankCondition<T> condition) {
        if (!this.conditionValues.containsKey(condition)) {
            throw new IllegalStateException("Asked speechbank context for the value of condition " + condition + ", but no value was set!");
        }
        return (T)this.conditionValues.get(condition);
    }

    public Set<Map.Entry<ReplaceableSpeechVariable, String>> getReplaceVariableValues() {
        return this.replaceVariableValues.entrySet();
    }
}

