/*
 * Decompiled with CFR 0.152.
 */
package lotr.curuquesta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lotr.curuquesta.ReplaceableSpeechVariable;
import lotr.curuquesta.SpeechbankCondition;

public class SpeechbankEngine {
    private final Map<String, SpeechbankCondition<?>> conditions = new HashMap();
    private final List<ReplaceableSpeechVariable> replaceableVariables = new ArrayList<ReplaceableSpeechVariable>();

    private SpeechbankEngine() {
    }

    public static SpeechbankEngine createInstance() {
        return new SpeechbankEngine();
    }

    public SpeechbankEngine registerCondition(String name, SpeechbankCondition<?> condition) {
        if (this.conditions.containsKey(name)) {
            throw new IllegalStateException(String.format("Speechbank condition %s is already registered", name));
        }
        this.conditions.put(name, condition);
        return this;
    }

    public SpeechbankEngine registerVariable(ReplaceableSpeechVariable variable) {
        if (this.replaceableVariables.stream().anyMatch(v -> v.aliasMatches(variable))) {
            throw new IllegalStateException(String.format("Speech variable %s conflicts with an already-registered alias", variable));
        }
        this.replaceableVariables.add(variable);
        return this;
    }
}

