/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lovely_snails.screen;

import dev.lambdaurora.lovely_snails.entity.SnailEntity;
import dev.lambdaurora.lovely_snails.registry.LovelySnailsRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class SnailScreenHandler
extends class_1703
implements class_1265 {
    private final class_1657 player;
    private final class_1277 inventory;
    private final SnailEntity entity;
    private int currentStoragePage;

    public SnailScreenHandler(int syncId, class_1661 playerInventory, class_2540 buf) {
        SnailEntity snail;
        class_1297 class_12972 = playerInventory.field_7546.method_5770().method_8469(buf.method_10816());
        this(syncId, playerInventory, class_12972 instanceof SnailEntity ? (snail = (SnailEntity)class_12972) : null, buf.readByte());
    }

    public SnailScreenHandler(int syncId, class_1661 playerInventory, SnailEntity snail, int currentStoragePage) {
        this(syncId, playerInventory, new class_1277(snail.getInventorySize()), snail, currentStoragePage);
    }

    public SnailScreenHandler(int syncId, class_1661 playerInventory, class_1277 inventory, SnailEntity entity, int currentStoragePage) {
        super(LovelySnailsRegistry.SNAIL_SCREEN_HANDLER_TYPE, syncId);
        SnailScreenHandler.method_17359((class_1263)inventory, (int)entity.getInventorySize());
        this.player = playerInventory.field_7546;
        this.inventory = inventory;
        this.entity = entity;
        this.currentStoragePage = currentStoragePage;
        inventory.method_5435(playerInventory.field_7546);
        this.inventory.method_5489((class_1265)this);
        this.method_7621(new SaddleSlot((class_1263)inventory, 0, 26, 18, entity));
        this.method_7621(new DecorSlot((class_1263)inventory, 1, 26, 36));
        this.method_7621(new ChestSlot((class_1263)inventory, 2, 8, 18, 0));
        this.method_7621(new ChestSlot((class_1263)inventory, 3, 8, 36, 1));
        this.method_7621(new ChestSlot((class_1263)inventory, 4, 8, 54, 2));
        for (int page = 0; page < 3; ++page) {
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 5; ++column) {
                    this.method_7621(new StorageSlot((class_1263)inventory, 5 + page * 15 + column + row * 5, 99 + column * 18, 18 + row * 18, page));
                }
            }
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new class_1735((class_1263)playerInventory, column + row * 9 + 9, 27 + column * 18, 102 + row * 18 + -18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.method_7621(new class_1735((class_1263)playerInventory, column, 27 + column * 18, 142));
        }
    }

    public SnailEntity snail() {
        return this.entity;
    }

    public class_1277 getInventory() {
        return this.inventory;
    }

    public boolean hasEnderChest() {
        for (int i = 2; i < 5; ++i) {
            if (!this.inventory.method_5438(i).method_31574(class_1802.field_8466)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChests() {
        for (int i = 0; i < 3; ++i) {
            if (!this.hasChest(i)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChest(int page) {
        return this.inventory.method_5438(2 + page).method_31574(class_1802.field_8106);
    }

    public boolean hasItemsInStoragePage(int page) {
        for (int slot = 5 + page * 15; slot < 5 + page * 15 + 15; ++slot) {
            if (this.inventory.method_5438(slot).method_7960()) continue;
            return true;
        }
        return false;
    }

    public int getCurrentStoragePage() {
        return this.currentStoragePage;
    }

    public void setCurrentStoragePage(int page) {
        this.currentStoragePage = page;
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)class_16572;
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_10804(this.field_7763);
            buffer.writeByte(page);
            ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)LovelySnailsRegistry.SNAIL_SET_STORAGE_PAGE, (class_2540)buffer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void requestStoragePage(int page) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10804(this.field_7763);
        buffer.writeByte(page);
        ClientPlayNetworking.send((class_2960)LovelySnailsRegistry.SNAIL_SET_STORAGE_PAGE, (class_2540)buffer);
    }

    public static int getOpeningStoragePage(class_1263 inventory) {
        for (int page = 0; page < 3; ++page) {
            if (!inventory.method_5438(2 + page).method_31574(class_1802.field_8106)) continue;
            return page;
        }
        return 0;
    }

    public boolean method_7597(class_1657 player) {
        return !this.entity.isInventoryDifferent((class_1263)this.inventory) && this.inventory.method_5443(player) && this.entity.method_5805() && this.entity.method_5739((class_1297)player) < 8.0f;
    }

    private boolean attemptToTransferSlotToCurrentPage(class_1799 currentStack) {
        int page = this.getCurrentStoragePage();
        return this.method_7616(currentStack, 5 + page * 15, 5 + page * 15 + 15, false);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 stack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 currentStack = slot.method_7677();
            stack = currentStack.method_7972();
            int inventorySize = this.inventory.method_5439();
            if (index < inventorySize) {
                if (!this.method_7616(currentStack, inventorySize, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (this.method_7611(2).method_7680(currentStack) && !this.method_7611(2).method_7681()) {
                if (!this.method_7616(currentStack, 2, 3, false)) {
                    return class_1799.field_8037;
                }
            } else if (this.method_7611(3).method_7680(currentStack) && !this.method_7611(3).method_7681()) {
                if (!this.method_7616(currentStack, 3, 4, false)) {
                    return class_1799.field_8037;
                }
            } else if (this.method_7611(4).method_7680(currentStack) && !this.method_7611(4).method_7681()) {
                if (!this.method_7616(currentStack, 4, 5, false)) {
                    return class_1799.field_8037;
                }
            } else if (this.method_7611(1).method_7680(currentStack) && !this.method_7611(1).method_7681()) {
                if (!this.method_7616(currentStack, 1, 2, false)) {
                    return class_1799.field_8037;
                }
            } else if (this.method_7611(0).method_7680(currentStack)) {
                if (!this.method_7616(currentStack, 0, 1, false)) {
                    return class_1799.field_8037;
                }
            } else if (!this.attemptToTransferSlotToCurrentPage(currentStack)) {
                int end = inventorySize + 27;
                int m = end + 9;
                if (index >= end && index < m ? !this.method_7616(currentStack, inventorySize, end, false) : (index < end ? !this.method_7616(currentStack, end, m, false) : !this.method_7616(currentStack, end, end, false))) {
                    return class_1799.field_8037;
                }
                return class_1799.field_8037;
            }
            if (currentStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (currentStack.method_7947() == stack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, currentStack);
        }
        return stack;
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == 0 && this.hasEnderChest()) {
            this.snail().openEnderChestInventory(player);
            return true;
        }
        return super.method_7604(player, id);
    }

    public void method_7595(class_1657 playerEntity) {
        super.method_7595(playerEntity);
        this.inventory.method_5432(playerEntity);
        this.inventory.method_5488((class_1265)this);
    }

    public void method_5453(class_1263 sender) {
        if (this.hasChests() && !this.hasChest(this.currentStoragePage)) {
            this.currentStoragePage = switch (this.currentStoragePage) {
                case 2 -> {
                    if (this.hasChest(1)) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> SnailScreenHandler.getOpeningStoragePage((class_1263)this.getInventory());
            };
        }
    }

    private static class SaddleSlot
    extends class_1735 {
        private final SnailEntity snail;

        public SaddleSlot(class_1263 inventory, int index, int x, int y, SnailEntity snail) {
            super(inventory, index, x, y);
            this.snail = snail;
        }

        public boolean method_7680(class_1799 stack) {
            return stack.method_31574(class_1802.field_8175) && !this.method_7681() && this.snail.method_6765();
        }

        public boolean method_7682() {
            return this.snail.method_6765();
        }
    }

    private static class DecorSlot
    extends class_1735 {
        public DecorSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7682() {
            return true;
        }

        public boolean method_7680(class_1799 stack) {
            return SnailEntity.getColorFromCarpet(stack) != null;
        }

        public int method_7675() {
            return 1;
        }
    }

    private class ChestSlot
    extends class_1735 {
        private final int storagePage;

        public ChestSlot(class_1263 inventory, int index, int x, int y, int storagePage) {
            super(inventory, index, x, y);
            this.storagePage = storagePage;
        }

        public boolean method_7682() {
            return !SnailScreenHandler.this.snail().method_6109();
        }

        public boolean method_7680(class_1799 stack) {
            return stack.method_31574(class_1802.field_8106) || stack.method_31574(class_1802.field_8466);
        }

        public boolean method_7674(class_1657 playerEntity) {
            return super.method_7674(playerEntity) && !SnailScreenHandler.this.hasItemsInStoragePage(this.storagePage);
        }

        public int method_7675() {
            return 1;
        }
    }

    private class StorageSlot
    extends class_1735 {
        private final int storagePage;

        public StorageSlot(class_1263 inventory, int index, int x, int y, int storagePage) {
            super(inventory, index, x, y);
            this.storagePage = storagePage;
        }

        public boolean method_7682() {
            return SnailScreenHandler.this.hasChest(this.storagePage) && SnailScreenHandler.this.currentStoragePage == this.storagePage;
        }
    }
}

