/*
 * Decompiled with CFR 0.152.
 */
package com.mcwdoors.kikoz.objects;

import com.mcwdoors.kikoz.init.SoundsInit;
import com.mcwdoors.kikoz.init.ToolInit;
import com.mcwdoors.kikoz.objects.GaragePart;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class GarageDoor
extends Block
implements IWaterLoggable {
    private static final EnumProperty<GaragePart> PART = EnumProperty.func_177709_a((String)"part", GaragePart.class);
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    String infoname;
    boolean hasTextInfo = true;
    protected static final VoxelShape TOP_SOUTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape TOP_EAST = Stream.of(Block.func_208617_a((double)6.0, (double)0.0, (double)-2.0, (double)10.0, (double)16.0, (double)16.0), Block.func_208617_a((double)6.6, (double)12.0, (double)-2.1, (double)6.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape TOP_WEST = Stream.of(Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0), Block.func_208617_a((double)10.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape TOP_NORTH = Stream.of(Block.func_208617_a((double)-2.2, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), Block.func_208617_a((double)-2.2, (double)12.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape EAST = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            return VoxelShapes.func_197880_a();
        }
        Boolean open = (Boolean)state.func_177229_b((IProperty)OPEN);
        GaragePart part = (GaragePart)((Object)state.func_177229_b(PART));
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case WEST: {
                if (open.booleanValue() && part == GaragePart.BOTTOM) {
                    return NORTH;
                }
                if (!open.booleanValue() && part == GaragePart.BOTTOM) {
                    return NORTH;
                }
                if (open.booleanValue() && part == GaragePart.TOP) {
                    return TOP_NORTH;
                }
                if (!open.booleanValue() && part == GaragePart.TOP) {
                    return NORTH;
                }
                return NORTH;
            }
            case EAST: {
                if (open.booleanValue() && part == GaragePart.BOTTOM) {
                    return SOUTH;
                }
                if (!open.booleanValue() && part == GaragePart.BOTTOM) {
                    return SOUTH;
                }
                if (open.booleanValue() && part == GaragePart.TOP) {
                    return TOP_SOUTH;
                }
                if (!open.booleanValue() && part == GaragePart.TOP) {
                    return SOUTH;
                }
                return SOUTH;
            }
            case NORTH: {
                if (open.booleanValue() && part == GaragePart.BOTTOM) {
                    return EAST;
                }
                if (!open.booleanValue() && part == GaragePart.BOTTOM) {
                    return EAST;
                }
                if (open.booleanValue() && part == GaragePart.TOP) {
                    return TOP_EAST;
                }
                if (!open.booleanValue() && part == GaragePart.TOP) {
                    return EAST;
                }
                return EAST;
            }
            case SOUTH: {
                if (open.booleanValue() && part == GaragePart.BOTTOM) {
                    return WEST;
                }
                if (!open.booleanValue() && part == GaragePart.BOTTOM) {
                    return WEST;
                }
                if (open.booleanValue() && part == GaragePart.TOP) {
                    return TOP_WEST;
                }
                if (!open.booleanValue() && part == GaragePart.TOP) {
                    return WEST;
                }
                return WEST;
            }
        }
        return WEST;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        Boolean open = (Boolean)state.func_177229_b((IProperty)OPEN);
        GaragePart part = (GaragePart)((Object)state.func_177229_b(PART));
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case WEST: {
                if (open.booleanValue() && part == GaragePart.BOTTOM) {
                    return NORTH;
                }
                if (!open.booleanValue() && part == GaragePart.BOTTOM) {
                    return NORTH;
                }
                if (open.booleanValue() && part == GaragePart.TOP) {
                    return TOP_NORTH;
                }
                if (!open.booleanValue() && part == GaragePart.TOP) {
                    return NORTH;
                }
                return NORTH;
            }
            case EAST: {
                if (open.booleanValue() && part == GaragePart.BOTTOM) {
                    return SOUTH;
                }
                if (!open.booleanValue() && part == GaragePart.BOTTOM) {
                    return SOUTH;
                }
                if (open.booleanValue() && part == GaragePart.TOP) {
                    return TOP_SOUTH;
                }
                if (!open.booleanValue() && part == GaragePart.TOP) {
                    return SOUTH;
                }
                return SOUTH;
            }
            case NORTH: {
                if (open.booleanValue() && part == GaragePart.BOTTOM) {
                    return EAST;
                }
                if (!open.booleanValue() && part == GaragePart.BOTTOM) {
                    return EAST;
                }
                if (open.booleanValue() && part == GaragePart.TOP) {
                    return TOP_EAST;
                }
                if (!open.booleanValue() && part == GaragePart.TOP) {
                    return EAST;
                }
                return EAST;
            }
            case SOUTH: {
                if (open.booleanValue() && part == GaragePart.BOTTOM) {
                    return WEST;
                }
                if (!open.booleanValue() && part == GaragePart.BOTTOM) {
                    return WEST;
                }
                if (open.booleanValue() && part == GaragePart.TOP) {
                    return TOP_WEST;
                }
                if (!open.booleanValue() && part == GaragePart.TOP) {
                    return WEST;
                }
                return WEST;
            }
        }
        return null;
    }

    public GarageDoor() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 5.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM)));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            IFluidState topFluidState = world.func_204610_c(pos.func_177981_b(1));
            Block block = world.func_180495_p(pos).func_177230_c();
            Block upper = world.func_180495_p(pos.func_177981_b(1)).func_177230_c();
            Block lower = world.func_180495_p(pos.func_177979_c(1)).func_177230_c();
            if (block == this && upper != block) {
                world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
            } else {
                world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
            }
            if (block == this && upper != block && lower != block) {
                world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
            }
            if (block == this && lower == block && upper != block) {
                world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
                world.func_180501_a(pos.func_177979_c(1), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
            }
            if (block == this && lower == block && upper == block) {
                world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
                world.func_180501_a(pos.func_177979_c(1), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        boolean bl = worldIn.func_175640_z(pos) || worldIn.func_175640_z(pos.func_177972_a(state.func_177229_b(PART) == GaragePart.BOTTOM ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
        if (blockIn != this) {
            if (flag != (Boolean)state.func_177229_b((IProperty)OPEN)) {
                // empty if block
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{PART, FACING, WATERLOGGED, OPEN});
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)OPEN);
    }

    public void toggleDoor(World worldIn, BlockPos pos, boolean open) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        if (blockstate.func_177230_c() == this && (Boolean)blockstate.func_177229_b((IProperty)OPEN) != open) {
            worldIn.func_180501_a(pos, (BlockState)blockstate.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open)), 10);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item != ToolInit.garage_remote) {
            return ActionResultType.PASS;
        }
        this.garageDoor(worldIn, pos, (Boolean)state.func_177229_b((IProperty)OPEN) == false, (Direction)state.func_177229_b((IProperty)FACING), 1000);
        worldIn.func_184133_a(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.8f);
        state = (BlockState)state.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(pos, state, 10);
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        IFluidState topFluidState = world.func_204610_c(pos.func_177981_b(1));
        Block block = world.func_180495_p(pos).func_177230_c();
        Block upper = world.func_180495_p(pos.func_177981_b(1)).func_177230_c();
        Block lower = world.func_180495_p(pos.func_177979_c(1)).func_177230_c();
        if (upper == block && lower == block) {
            world.func_180501_a(pos.func_177979_c(1), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
        }
        if (lower == block) {
            world.func_180501_a(pos.func_177979_c(1), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(topFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
        }
    }

    private void garageDoor(World world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            boolean open = (Boolean)state.func_177229_b((IProperty)OPEN);
            Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
            if (open != targetOpen && direction.equals((Object)targetDirection)) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(targetOpen)), 6);
                switch (targetDirection) {
                    case NORTH: 
                    case SOUTH: {
                        this.garageDoor(world, pos.func_177970_e(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177964_d(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1).func_177970_e(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1).func_177964_d(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2).func_177970_e(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2).func_177964_d(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1).func_177970_e(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1).func_177964_d(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1), targetOpen, targetDirection, depth - 2);
                    }
                    case WEST: 
                    case EAST: {
                        this.garageDoor(world, pos.func_177965_g(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177985_f(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1).func_177965_g(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1).func_177985_f(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2).func_177965_g(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2).func_177985_f(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177979_c(2), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1).func_177965_g(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1).func_177985_f(1), targetOpen, targetDirection, depth - 2);
                        this.garageDoor(world, pos.func_177981_b(1), targetOpen, targetDirection, depth - 2);
                    }
                }
                return;
            }
        }
    }
}

