/*
 * Decompiled with CFR 0.152.
 */
package com.mcwdoors.kikoz;

import com.mcwdoors.kikoz.init.BlockInit;
import com.mcwdoors.kikoz.init.ItemInit;
import com.mcwdoors.kikoz.init.SoundsInit;
import com.mcwdoors.kikoz.init.ToolInit;
import com.mcwdoors.kikoz.objects.GarageRemote;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="mcwdoors")
@Mod.EventBusSubscriber(modid="mcwdoors", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MacawsDoors {
    public static final String MOD_ID = "mcwdoors";
    public static MacawsDoors instance;
    public static final CreativeModeTab DoorItemGroup;

    public MacawsDoors() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        ItemInit.ITEMS.register(modEventBus);
        BlockInit.BLOCKS.register(modEventBus);
        SoundsInit.SOUNDS.register(modEventBus);
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        BlockInit.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties().m_41491_(DoorItemGroup);
            BlockItem blockItem = new BlockItem(block, properties);
            blockItem.setRegistryName(block.getRegistryName());
            registry.register((IForgeRegistryEntry)blockItem);
        });
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    private static ResourceLocation location(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    static {
        DoorItemGroup = new CreativeModeTab(MOD_ID){

            @Nonnull
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)BlockInit.OAK_MODERN_DOOR.get());
            }
        };
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ToolInit.garage_remote = (Item)new GarageRemote().setRegistryName(MacawsDoors.location("garage_remote"))});
        }
    }
}

