/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.megamario;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.List;

public class Config {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static Config INSTANCE;
    private int starman_timer = 24;
    private String[] blacklisted_blocks = new String[]{"minecraft:bedrock"};
    private String[] trigger_items = new String[]{"minecraft:red_mushroom"};
    private boolean kill_entities = true;
    private boolean drop_blocks = true;
    private transient List<String> blacklistedBlocks;
    private transient List<String> triggerItems;

    public Config() {
        INSTANCE = this;
    }

    public int getStarmanTimer() {
        return this.starman_timer;
    }

    public static void load() {
        File file = new File("config/megamario.json");
        if (!file.exists()) {
            Config.generate();
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            String s = null;
            while ((s = reader.readLine()) != null) {
                sb.append(s);
            }
            reader.close();
            INSTANCE = (Config)GSON.fromJson(sb.toString(), Config.class);
        }
        catch (Exception e) {
            INSTANCE = new Config();
        }
        Config.INSTANCE.blacklistedBlocks = Arrays.asList(Config.INSTANCE.blacklisted_blocks);
        Config.INSTANCE.triggerItems = Arrays.asList(Config.INSTANCE.trigger_items);
    }

    public List getBlacklistedBlocks() {
        return this.blacklistedBlocks;
    }

    public List getTriggerItems() {
        return this.triggerItems;
    }

    public boolean shouldKillEntities() {
        return this.kill_entities;
    }

    public boolean shouldDropBlocks() {
        return this.drop_blocks;
    }

    private static void generate() {
        File file = new File("config/megamario.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        INSTANCE = new Config();
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(GSON.toJson((Object)INSTANCE));
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

