/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.megamario;

import com.swdteam.megamario.Config;
import com.swdteam.megamario.NetworkHandler;
import com.swdteam.megamario.PacketSendMegaData;
import com.swdteam.megamario.RenderOverlay;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="megamario")
public class MegaStarmanSteve {
    public static final String MODID = "megamario";
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"megamario");
    public static final RegistryObject<SoundEvent> STAR_THEME = MegaStarmanSteve.buildSound(SOUNDS, "mm.star_song");
    public static final RegistryObject<SoundEvent> SHRINK = MegaStarmanSteve.buildSound(SOUNDS, "mm.shrink");
    public static Map<UUID, Long> MEGAS = new HashMap<UUID, Long>();

    public MegaStarmanSteve() {
        Config.load();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new RenderOverlay());
        SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static RegistryObject<SoundEvent> buildSound(DeferredRegister<SoundEvent> register, String registryName) {
        RegistryObject SOUND = register.register(registryName, () -> new SoundEvent(new ResourceLocation(MODID, registryName)));
        return SOUND;
    }

    private void setup(FMLCommonSetupEvent event) {
        NetworkHandler.register();
    }

    public static void makeMega(PlayerEntity player) {
        if (!player.func_130014_f_().field_72995_K) {
            MEGAS.put(player.func_110124_au(), System.currentTimeMillis() / 1000L);
            NetworkHandler.sendToAllClients(new PacketSendMegaData(player.func_110124_au(), true));
            player.func_213323_x_();
        }
    }

    public static void makeNotMega(PlayerEntity player) {
        if (!player.func_130014_f_().field_72995_K) {
            MEGAS.remove(player.func_110124_au());
            NetworkHandler.sendToAllClients(new PacketSendMegaData(player.func_110124_au(), false));
            player.func_213323_x_();
        }
    }

    @SubscribeEvent
    public void eyeEvent(EntityEvent.Size e) {
        if (e.getEntity() instanceof PlayerEntity && MEGAS.containsKey(((PlayerEntity)e.getEntity()).func_110124_au())) {
            e.setNewEyeHeight(3.0f);
        }
    }

    @SubscribeEvent
    public void collideEvent(LivingEvent.LivingUpdateEvent e) {
        ServerPlayerEntity player;
        if (e.getEntityLiving() instanceof ServerPlayerEntity && MEGAS.containsKey((player = (ServerPlayerEntity)e.getEntityLiving()).func_110124_au())) {
            long startTime = MEGAS.get(player.func_110124_au());
            if (System.currentTimeMillis() / 1000L - startTime >= (long)Config.INSTANCE.getStarmanTimer()) {
                MegaStarmanSteve.makeNotMega((PlayerEntity)player);
                return;
            }
            AxisAlignedBB box = player.func_174813_aQ().func_72314_b(1.5, 2.0, 1.5).func_72317_d(0.0, 2.0, 0.0);
            int x = (int)box.field_72340_a;
            while ((double)x <= box.field_72336_d) {
                int y = (int)box.field_72338_b;
                while ((double)y <= box.field_72337_e) {
                    int z = (int)box.field_72339_c;
                    while ((double)z <= box.field_72334_f) {
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = player.func_130014_f_().func_180495_p(pos);
                        if (!(state.func_177230_c() instanceof IFluidBlock) && state.func_177230_c() != Blocks.field_150355_j && state.func_177230_c() != Blocks.field_150353_l && !Config.INSTANCE.getBlacklistedBlocks().contains(state.func_177230_c().getRegistryName().toString())) {
                            player.func_130014_f_().func_175655_b(pos, Config.INSTANCE.shouldDropBlocks());
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            if (Config.INSTANCE.shouldKillEntities()) {
                List entities = player.func_130014_f_().func_217357_a(LivingEntity.class, box);
                for (int i = 0; i < entities.size(); ++i) {
                    LivingEntity ent = (LivingEntity)entities.get(i);
                    if (ent.equals((Object)player) || ent instanceof PlayerEntity && ((PlayerEntity)ent).func_184812_l_()) continue;
                    ((LivingEntity)entities.get(i)).func_174812_G();
                }
            }
        }
    }

    @SubscribeEvent
    public void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (Config.INSTANCE.getTriggerItems().contains(event.getItemStack().func_77973_b().getRegistryName().toString())) {
                MegaStarmanSteve.makeMega(player);
                event.getItemStack().func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public void hurtEvent(LivingHurtEvent e) {
        if (e.getEntityLiving() instanceof PlayerEntity && MEGAS.containsKey(((PlayerEntity)e.getEntityLiving()).func_110124_au())) {
            e.setCanceled(true);
        }
    }
}

