/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.megamario;

import com.swdteam.megamario.Config;
import com.swdteam.megamario.NetworkHandler;
import com.swdteam.megamario.PacketSendMegaData;
import com.swdteam.megamario.RenderOverlay;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="megamario")
public class MegaStarmanSteve {
    public static final String MODID = "megamario";
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"megamario");
    public static final RegistryObject<SoundEvent> STAR_THEME = MegaStarmanSteve.buildSound(SOUNDS, "mm.star_song");
    public static final RegistryObject<SoundEvent> SHRINK = MegaStarmanSteve.buildSound(SOUNDS, "mm.shrink");
    public static Map<UUID, Long> MEGAS = new HashMap<UUID, Long>();

    public MegaStarmanSteve() {
        Config.load();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new RenderOverlay());
        SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static RegistryObject<SoundEvent> buildSound(DeferredRegister<SoundEvent> register, String registryName) {
        RegistryObject SOUND = register.register(registryName, () -> new SoundEvent(new ResourceLocation(MODID, registryName)));
        return SOUND;
    }

    private void setup(FMLCommonSetupEvent event) {
        NetworkHandler.register();
    }

    public static void makeMega(Player player) {
        if (!player.m_20193_().f_46443_) {
            MEGAS.put(player.m_142081_(), System.currentTimeMillis() / 1000L);
            NetworkHandler.sendToAllClients(new PacketSendMegaData(player.m_142081_(), true));
            player.m_6210_();
        }
    }

    public static void makeNotMega(Player player) {
        if (!player.m_20193_().f_46443_) {
            MEGAS.remove(player.m_142081_());
            NetworkHandler.sendToAllClients(new PacketSendMegaData(player.m_142081_(), false));
            player.m_6210_();
        }
    }

    @SubscribeEvent
    public void eyeEvent(EntityEvent.Size e) {
        if (e.getEntity() instanceof Player && MEGAS.containsKey(((Player)e.getEntity()).m_142081_())) {
            e.setNewEyeHeight(3.0f);
        }
    }

    @SubscribeEvent
    public void collideEvent(LivingEvent.LivingUpdateEvent e) {
        ServerPlayer player;
        if (e.getEntityLiving() instanceof ServerPlayer && MEGAS.containsKey((player = (ServerPlayer)e.getEntityLiving()).m_142081_())) {
            long startTime = MEGAS.get(player.m_142081_());
            if (System.currentTimeMillis() / 1000L - startTime >= (long)Config.INSTANCE.getStarmanTimer()) {
                MegaStarmanSteve.makeNotMega((Player)player);
                return;
            }
            AABB box = player.m_142469_().m_82377_(1.5, 2.0, 1.5).m_82386_(0.0, 2.0, 0.0);
            int x = (int)box.f_82288_;
            while ((double)x <= box.f_82291_) {
                int y = (int)box.f_82289_;
                while ((double)y <= box.f_82292_) {
                    int z = (int)box.f_82290_;
                    while ((double)z <= box.f_82293_) {
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = player.m_20193_().m_8055_(pos);
                        if (!(state.m_60734_() instanceof IFluidBlock) && state.m_60734_() != Blocks.f_49990_ && state.m_60734_() != Blocks.f_49991_ && !Config.INSTANCE.getBlacklistedBlocks().contains(state.m_60734_().getRegistryName().toString())) {
                            player.m_20193_().m_46961_(pos, Config.INSTANCE.shouldDropBlocks());
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            if (Config.INSTANCE.shouldKillEntities()) {
                List entities = player.m_20193_().m_45976_(LivingEntity.class, box);
                for (int i = 0; i < entities.size(); ++i) {
                    LivingEntity ent = (LivingEntity)entities.get(i);
                    if (ent.equals((Object)player) || ent instanceof Player && ((Player)ent).m_7500_()) continue;
                    ((LivingEntity)entities.get(i)).m_6074_();
                }
            }
        }
    }

    @SubscribeEvent
    public void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityLiving() instanceof Player) {
            Player player = (Player)event.getEntityLiving();
            if (Config.INSTANCE.getTriggerItems().contains(event.getItemStack().m_41720_().getRegistryName().toString())) {
                MegaStarmanSteve.makeMega(player);
                event.getItemStack().m_41774_(1);
            }
        }
    }

    @SubscribeEvent
    public void hurtEvent(LivingHurtEvent e) {
        if (e.getEntityLiving() instanceof Player && MEGAS.containsKey(((Player)e.getEntityLiving()).m_142081_())) {
            e.setCanceled(true);
        }
    }
}

