/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.megamario;

import com.swdteam.megamario.MegaStarmanSteve;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PacketSendMegaData {
    public static SimpleSoundInstance SOUND;
    private UUID playerUUID;
    private boolean grow;

    public PacketSendMegaData(UUID playerUUID, boolean grow) {
        this.playerUUID = playerUUID;
        this.grow = grow;
    }

    public static void encode(PacketSendMegaData msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.playerUUID);
        buf.writeBoolean(msg.grow);
    }

    public static PacketSendMegaData decode(FriendlyByteBuf buf) {
        return new PacketSendMegaData(buf.m_130259_(), buf.readBoolean());
    }

    public static void handle(PacketSendMegaData msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getNetworkManager().getDirection() == PacketFlow.CLIENTBOUND) {
            PacketSendMegaData.clientCode(msg, ctx);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientCode(PacketSendMegaData msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player;
            if (msg.grow) {
                MegaStarmanSteve.MEGAS.put(msg.playerUUID, System.currentTimeMillis() / 1000L);
                if (msg.playerUUID.equals(Minecraft.m_91087_().f_91074_.m_142081_())) {
                    if (Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)SOUND)) {
                        Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)SOUND);
                    }
                    Minecraft.m_91087_().m_91106_().m_120405_();
                    SOUND = SimpleSoundInstance.m_119745_((SoundEvent)((SoundEvent)MegaStarmanSteve.STAR_THEME.get()));
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SOUND);
                }
            } else {
                MegaStarmanSteve.MEGAS.remove(msg.playerUUID);
                if (Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)SOUND)) {
                    Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)SOUND);
                }
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)MegaStarmanSteve.SHRINK.get()), (float)1.0f));
            }
            if ((player = Minecraft.m_91087_().f_91074_.m_20193_().m_46003_(msg.playerUUID)) != null) {
                for (int i = 0; i < 25; ++i) {
                    player.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, player.m_20182_().f_82479_ + (Math.random() - 0.5), player.m_20182_().f_82480_ + Math.random() * 2.5, player.m_20182_().f_82481_ + (Math.random() - 0.5), (Math.random() - 0.5) / 4.0, (double)0.1f, (Math.random() - 0.5) / 4.0);
                    player.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, player.m_20182_().f_82479_ + (Math.random() - 0.5), player.m_20182_().f_82480_ + Math.random() * 4.0, player.m_20182_().f_82481_ + (Math.random() - 0.5), (Math.random() - 0.5) / 4.0, (double)0.1f, (Math.random() - 0.5) / 4.0);
                }
                player.m_6210_();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

