/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.entity;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeNetwork;
import com.dairymoose.modernlife.network.play.client.CBikeDismountPacket;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class BicycleEntity
extends Entity {
    public static final EntityType<BicycleEntity> BICYCLE_ENTITY = EntityType.Builder.func_220322_a(BicycleEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 1.01f).func_233606_a_(10).func_206830_a(new ResourceLocation("modernlife", "bicycle").toString());
    private float velocity = 0.0f;
    private float downward_velocity = 0.0f;
    public static final float MAX_SPEED = 0.42f;
    public static final float MIN_SPEED = 0.05f;
    public static final float REVERSE_MAX_SPEED = -0.14f;
    public static final int TICKS_PER_JUMP = 6;
    public static final float MAX_ANGLE_DELTA = 10.0f;
    public static final float SPEED_INCREASE_CONSTANT = 0.0085f;
    public float maxSpeedIncrease = 1.0f;
    public Vector3d lastPos = null;
    private float jumpStep = -1.0f;
    public boolean recentDismount = false;
    public float renderWheelRot = 0.0f;
    public Vector3d lastRenderPos = null;
    public long lastRenderTime = 0L;
    private static final DataParameter<Integer> DATA_ID_HURT = EntityDataManager.func_187226_a(BicycleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_ID_HURTDIR = EntityDataManager.func_187226_a(BicycleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DATA_ID_DAMAGE = EntityDataManager.func_187226_a(BicycleEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public void setVelocity(float velocity) {
        this.velocity = velocity;
    }

    public void setSpeedBoost(float speedBoost) {
        this.maxSpeedIncrease = speedBoost;
    }

    public void setDownwardVelocity(float downward_velocity) {
        this.downward_velocity = downward_velocity;
    }

    public void setJumpStep(float jumpStep) {
        this.jumpStep = jumpStep;
    }

    public BicycleEntity(EntityType<? extends BicycleEntity> p_i50238_1_, World p_i50238_2_) {
        super(p_i50238_1_, p_i50238_2_);
        this.field_70138_W = 1.0f;
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_184207_aI()) {
            return super.func_184230_a(player, hand);
        }
        if (!this.field_70170_p.field_72995_K) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            player.func_184220_m((Entity)this);
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    public void func_184232_k(Entity p_184232_1_) {
        super.func_184232_k(p_184232_1_);
        if (p_184232_1_ instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)p_184232_1_;
        }
        float f3 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
        float f = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
        float f1 = 0.38f;
        float f2 = 0.65f;
        p_184232_1_.func_70107_b(this.func_226277_ct_() + (double)(f1 * f3), this.func_226278_cu_() + this.func_70042_X() + p_184232_1_.func_70033_W() + (double)f2, this.func_226281_cx_() - (double)(f1 * f));
        if (p_184232_1_ instanceof LivingEntity) {
            // empty if block
        }
    }

    protected boolean func_184219_q(Entity p_184219_1_) {
        return this.velocity == 0.0f && this.func_184188_bt().size() < 1;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public Vector3d func_230268_c_(LivingEntity p_230268_1_) {
        return super.func_230268_c_(p_230268_1_);
    }

    protected void func_184225_p(Entity p_184225_1_) {
        field_184243_a.debug((Object)p_184225_1_.field_70170_p);
        this.lastPos = null;
        if (p_184225_1_.field_70170_p.field_72995_K) {
            ModernLifeNetwork.INSTANCE.sendToServer((Object)new CBikeDismountPacket(this.func_213303_ch(), this.jumpStep, this.velocity, this.downward_velocity, this.func_145782_y()));
        }
        super.func_184225_p(p_184225_1_);
    }

    protected void func_184200_o(Entity p_184200_1_) {
        this.lastPos = null;
        super.func_184200_o(p_184200_1_);
    }

    protected float func_213316_a(Pose p_213316_1_, EntitySize p_213316_2_) {
        return p_213316_2_.field_220316_b;
    }

    private float angularDifference(float angle1, float angle2) {
        float diff;
        if ((angle1 %= 360.0f) < 0.0f) {
            angle1 += 360.0f;
        }
        if ((angle2 %= 360.0f) < 0.0f) {
            angle2 += 360.0f;
        }
        if ((diff = angle2 - angle1) > 180.0f) {
            diff = -(360.0f - diff);
        } else if (diff < -180.0f) {
            diff = 360.0f + diff;
        }
        return diff;
    }

    private void applyNewFacing(float facing) {
        this.field_70126_B = this.field_70177_z = facing;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
    }

    protected void clampRotation(Entity p_184454_1_) {
        if (p_184454_1_ != null) {
            p_184454_1_.func_181013_g(this.field_70177_z);
            float f = MathHelper.func_76142_g((float)(p_184454_1_.field_70177_z - this.field_70177_z));
            float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
            p_184454_1_.field_70126_B += f1 - f;
            p_184454_1_.field_70177_z += f1 - f;
            p_184454_1_.func_70034_d(p_184454_1_.field_70177_z);
        }
    }

    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
        this.field_70143_R *= 0.88f;
        super.func_184231_a(p_184231_1_, p_184231_3_, p_184231_4_, p_184231_5_);
    }

    public void setDamage(float p_70266_1_) {
        this.field_70180_af.func_187227_b(DATA_ID_DAMAGE, (Object)Float.valueOf(p_70266_1_));
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int p_70265_1_) {
        this.field_70180_af.func_187227_b(DATA_ID_HURT, (Object)p_70265_1_);
    }

    public int getHurtTime() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_ID_HURT);
    }

    public int getHurtDir() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_ID_HURTDIR);
    }

    public void setHurtDir(int p_70269_1_) {
        this.field_70180_af.func_187227_b(DATA_ID_HURTDIR, (Object)p_70269_1_);
    }

    public Item getDropItem() {
        return CustomBlocks.ITEM_BICYCLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + p_70097_2_ * 20.0f);
            this.func_70018_K();
            boolean bl = flag = p_70097_1_.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)p_70097_1_.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamage() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199703_a((IItemProvider)this.getDropItem());
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void advanceMovement(LivingEntity livingEntity, float speed, boolean jumping) {
        double positionDelta;
        if (this.lastPos != null && (positionDelta = this.func_213303_ch().func_72438_d(this.lastPos)) <= 0.04) {
            if (this.velocity >= 0.05f) {
                this.velocity *= 0.2f;
            }
            if (positionDelta <= 0.01) {
                this.downward_velocity = 0.0f;
            }
        }
        this.velocity = this.downward_velocity == 0.0f ? (this.velocity *= 0.985f) : (this.velocity *= 0.998f);
        if ((double)speed != 0.0 && this.downward_velocity == 0.0f) {
            float speedIncrease = 0.0085f;
            if (speed < 0.0f) {
                speedIncrease *= 0.75f;
            }
            float increment = speed * speedIncrease;
            this.velocity += increment;
            if (this.velocity > 0.42f * this.maxSpeedIncrease) {
                this.velocity = 0.42f * this.maxSpeedIncrease;
            } else if (this.velocity < -0.14f * this.maxSpeedIncrease) {
                this.velocity = -0.14f * this.maxSpeedIncrease;
            }
        } else if (this.velocity > 0.0f && this.velocity <= 0.05f) {
            this.velocity = 0.0f;
        } else if (this.velocity < 0.0f && this.velocity >= -0.05f) {
            this.velocity = 0.0f;
        }
        if (this.maxSpeedIncrease > 1.0f) {
            this.maxSpeedIncrease = 1.0f;
        }
        if (this.field_70170_p.func_204610_c(this.func_233580_cy_()).func_206886_c() != Fluids.field_204541_a) {
            this.velocity = (float)((double)this.velocity * 0.9);
        }
        if (this.func_208600_a((ITag)FluidTags.field_206959_a) || this.func_208600_a((ITag)FluidTags.field_206960_b)) {
            this.downward_velocity = (float)((double)this.downward_velocity * 0.2);
        }
        if (this.velocity != 0.0f && livingEntity != null && this.downward_velocity == 0.0f) {
            float facingAngle = livingEntity.field_70177_z;
            float bikeYRot = this.field_70177_z;
            float livingYRot = livingEntity.field_70177_z;
            float angleDelta = this.angularDifference(bikeYRot, livingYRot);
            if (Math.abs(angleDelta) > 10.0f) {
                facingAngle = angleDelta > 0.0f ? bikeYRot + Math.min(Math.abs(angleDelta), 10.0f) : bikeYRot - Math.min(Math.abs(angleDelta), 10.0f);
            }
            this.applyNewFacing(facingAngle);
        }
        BlockState currentState = this.field_70170_p.func_180495_p(this.func_233580_cy_());
        BlockState currentBelowState = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b());
        float friction = currentBelowState.getSlipperiness((IWorldReader)this.field_70170_p, this.func_233580_cy_().func_177977_b(), (Entity)this);
        float frictionPercent = (friction -= 0.6f) / 0.4f;
        float maxFrictionSlowdown = 0.012f;
        float frictionSlowdownFactor = 1.0f - maxFrictionSlowdown * frictionPercent;
        this.velocity *= frictionSlowdownFactor;
        this.func_213293_j((double)this.velocity * Math.cos(Math.toRadians(this.field_70177_z + 90.0f)), -this.downward_velocity, (double)this.velocity * Math.sin(Math.toRadians(this.field_70177_z + 90.0f)));
        if (this.func_96092_aw()) {
            Vector3d fluidFlow = this.field_70170_p.func_204610_c(this.func_233580_cy_()).func_215673_c((IBlockReader)this.field_70170_p, this.func_233580_cy_());
            fluidFlow = fluidFlow.func_186678_a(0.01);
            this.func_213317_d(this.func_213322_ci().func_178787_e(fluidFlow));
        }
        Vector3d moveToVec = this.func_213303_ch().func_178787_e(new Vector3d(this.func_213322_ci().field_72450_a, 0.0, this.func_213322_ci().field_72449_c).func_186678_a(2.0));
        BlockPos moveToPos = new BlockPos(moveToVec.field_72450_a, moveToVec.field_72448_b, moveToVec.field_72449_c);
        BlockState moveToState = this.field_70170_p.func_180495_p(moveToPos);
        BlockState moveToAboveState = this.field_70170_p.func_180495_p(moveToPos.func_177984_a());
        BlockState moveToBelowState = this.field_70170_p.func_180495_p(moveToPos.func_177977_b());
        boolean pathable = moveToState.func_177230_c().func_196266_a(moveToState, (IBlockReader)this.field_70170_p, moveToPos, PathType.LAND);
        boolean pathableAbove = moveToAboveState.func_177230_c().func_196266_a(moveToAboveState, (IBlockReader)this.field_70170_p, moveToPos.func_177984_a(), PathType.LAND);
        BlockState stateToCheck = currentState;
        BlockPos posToCheck = this.func_233580_cy_();
        if (stateToCheck.func_196958_f()) {
            stateToCheck = currentBelowState;
            posToCheck = posToCheck.func_177977_b();
        }
        double currentHeight = 0.0;
        VoxelShape groundShape = stateToCheck.func_177230_c().func_220071_b(stateToCheck, (IBlockReader)this.field_70170_p, posToCheck, ISelectionContext.func_216377_a());
        if (!groundShape.equals(VoxelShapes.func_197880_a())) {
            currentHeight = groundShape.func_197758_c(Direction.Axis.Y);
        }
        double moveToHeight = 0.0;
        VoxelShape moveToShape = moveToState.func_177230_c().func_220071_b(moveToState, (IBlockReader)this.field_70170_p, moveToPos, ISelectionContext.func_216377_a());
        if (!moveToShape.equals(VoxelShapes.func_197880_a())) {
            moveToHeight = moveToShape.func_197758_c(Direction.Axis.Y);
        }
        double jumpHeight = 0.0;
        if (jumping && this.downward_velocity == 0.0f && this.jumpStep < 0.0f) {
            this.jumpStep = 0.0f;
        }
        if (this.jumpStep >= 0.0f) {
            jumpHeight = 0.4 * (double)(this.velocity / 0.42f) * Math.sin(Math.toRadians(this.jumpStep));
            this.jumpStep += 30.0f;
        }
        if (this.jumpStep >= 180.0f) {
            this.jumpStep = -1.0f;
        }
        double heightDiff = moveToHeight - currentHeight;
        double groundY = (double)posToCheck.func_177956_o() + currentHeight;
        if (!currentState.func_196958_f()) {
            // empty if block
        }
        if (currentBelowState.func_196958_f() || this.func_213303_ch().field_72448_b > groundY) {
            this.downward_velocity += 0.03f;
        } else {
            if (this.downward_velocity != 0.0f && currentBelowState.func_204520_s().func_206888_e()) {
                float damageDone;
                if (livingEntity != null) {
                    this.applyNewFacing(livingEntity.field_70177_z);
                }
                if (!((damageDone = this.downward_velocity * 1.12f) > 1.0f) || livingEntity != null) {
                    // empty if block
                }
                if (livingEntity instanceof PlayerEntity) {
                    PlayerEntity playerEntity = (PlayerEntity)livingEntity;
                    if ((double)damageDone >= 1.0) {
                        this.field_70170_p.func_184133_a(playerEntity, this.func_233580_cy_(), SoundEvents.field_187655_bw, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    } else if ((double)damageDone > 0.2) {
                        this.field_70170_p.func_184133_a(playerEntity, this.func_233580_cy_(), SoundEvents.field_187545_bE, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
            this.downward_velocity = 0.0f;
        }
        this.func_213293_j(this.func_213322_ci().field_72450_a, (double)(-this.downward_velocity) + jumpHeight, this.func_213322_ci().field_72449_c);
        this.lastPos = this.func_213303_ch();
        if (this.field_70170_p instanceof ServerWorld || this.func_184207_aI() && this.func_184186_bw()) {
            Vector3d toMove = this.func_213322_ci();
            if (this.downward_velocity == 0.0f) {
                Vector3d mov = this.func_213322_ci();
                this.func_213293_j(mov.field_72450_a, mov.field_72448_b - 0.01, mov.field_72449_c);
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
        this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public void func_70071_h_() {
        boolean jumping = false;
        float speed = 0.0f;
        LivingEntity livingEntity = null;
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (this.field_70170_p.field_72995_K) {
            livingEntity = (LivingEntity)this.func_184179_bs();
            if (this.func_184207_aI() && this.func_184186_bw()) {
                float xDelta = livingEntity.field_70702_br;
                float zDelta = livingEntity.field_191988_bg;
                xDelta = 0.0f;
                if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
                    jumping = true;
                }
                speed = xDelta * xDelta + zDelta * zDelta;
                double headingDegrees = Math.toDegrees(Math.atan2(zDelta, xDelta));
                if (headingDegrees < 0.0) {
                    speed = -speed;
                }
            }
            this.advanceMovement(livingEntity, speed, jumping);
        } else if (this.velocity > 0.0f || this.downward_velocity > 0.0f) {
            this.advanceMovement(livingEntity, speed, jumping);
            if (this.velocity == 0.0f && this.recentDismount) {
                this.recentDismount = false;
            }
        }
        super.func_70071_h_();
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return -0.15;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean canWearArmor() {
        return true;
    }

    public boolean isArmor(ItemStack p_190682_1_) {
        return p_190682_1_.func_77973_b() instanceof HorseArmorItem;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA_ID_HURT, (Object)0);
        this.field_70180_af.func_187214_a(DATA_ID_HURTDIR, (Object)1);
        this.field_70180_af.func_187214_a(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void func_70037_a(CompoundNBT var1) {
    }

    protected void func_213281_b(CompoundNBT var1) {
    }
}

