/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.entity;

import com.dairymoose.entity.BicycleEntity;
import com.dairymoose.entity.BicycleModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public final class BicycleRenderer
extends EntityRenderer<BicycleEntity> {
    private BicycleModel bicycleModel = new BicycleModel();
    private float modelScale = 1.0f;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation texture = new ResourceLocation("modernlife", "textures/entity/bicycle_uv.png");

    public BicycleRenderer(EntityRendererManager p_i47205_1_) {
        super(p_i47205_1_);
    }

    public boolean shouldRender(BicycleEntity p_225626_1_, ClippingHelper p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        return true;
    }

    public void render(BicycleEntity bicycleEntity, float p_225623_2_, float p_225623_3_, MatrixStack matrixStack, IRenderTypeBuffer buffer, int p_225623_6_) {
        float t;
        float calcSpeed = 0.0f;
        Vector3d pos = bicycleEntity.func_213303_ch();
        if (bicycleEntity.lastRenderPos != null && (double)(t = (float)(System.currentTimeMillis() - bicycleEntity.lastRenderTime) / 1000.0f) >= 0.05) {
            pos = new Vector3d(pos.field_72450_a, 0.0, pos.field_72449_c);
            bicycleEntity.lastRenderPos = new Vector3d(bicycleEntity.lastRenderPos.field_72450_a, 0.0, bicycleEntity.lastRenderPos.field_72449_c);
            float distSqr = (float)pos.func_72436_e(bicycleEntity.lastRenderPos);
            float dist = MathHelper.func_76129_c((float)distSqr);
            calcSpeed = dist / t;
            float increment = calcSpeed / 15.0f;
            bicycleEntity.renderWheelRot = (bicycleEntity.renderWheelRot + increment) % 360.0f;
            bicycleEntity.lastRenderPos = pos;
            bicycleEntity.lastRenderTime = System.currentTimeMillis();
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 1.5, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - p_225623_2_));
        float lvt_7_1_ = (float)bicycleEntity.getHurtTime() - p_225623_3_;
        float lvt_8_1_ = bicycleEntity.getDamage() - p_225623_3_;
        if (lvt_8_1_ < 0.0f) {
            lvt_8_1_ = 0.0f;
        }
        if (lvt_7_1_ > 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76126_a((float)lvt_7_1_) * lvt_7_1_ * lvt_8_1_ / 10.0f * (float)bicycleEntity.getHurtDir()));
        }
        matrixStack.func_227862_a_(-this.modelScale, -this.modelScale, this.modelScale);
        this.bicycleModel.setupAnim(bicycleEntity, p_225623_3_, 0.0f, -0.1f, 0.0f, 0.0f);
        IVertexBuilder builder = buffer.getBuffer(this.bicycleModel.func_228282_a_(this.getTextureLocation(bicycleEntity)));
        this.bicycleModel.renderToBufferWithRotation(bicycleEntity.renderWheelRot, matrixStack, builder, p_225623_6_, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
        if (bicycleEntity.lastRenderPos == null) {
            bicycleEntity.lastRenderPos = pos;
            bicycleEntity.lastRenderTime = System.currentTimeMillis();
        }
        super.func_225623_a_((Entity)bicycleEntity, p_225623_2_, p_225623_3_, matrixStack, buffer, p_225623_6_);
    }

    public ResourceLocation getTextureLocation(BicycleEntity var1) {
        return texture;
    }
}

