/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.CanvasTileEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class CanvasBlock
extends Block {
    protected static final VoxelShape SHAPE_SOUTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    protected static final VoxelShape SHAPE_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final IntegerProperty SIZE = IntegerProperty.func_177719_a((String)"size", (int)1, (int)4);
    public static final int MAX_SIZE = (Integer)SIZE.func_177700_c().stream().max((i, i2) -> i - i2).get();

    public CanvasBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151593_r).harvestTool(ToolType.AXE).harvestLevel(0).func_200947_a(SoundType.field_222468_o).func_200948_a(1.0f, 10.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.SOUTH)).func_206870_a((Property)SIZE, (Comparable)Integer.valueOf(1)));
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            TileEntity lvt_6_1_ = p_196243_2_.func_175625_s(p_196243_3_);
            if (lvt_6_1_ instanceof CanvasTileEntity) {
                InventoryHelper.func_180175_a((World)p_196243_2_, (BlockPos)p_196243_3_, (IInventory)((CanvasTileEntity)lvt_6_1_));
                p_196243_2_.func_175666_e(p_196243_3_, (Block)this);
            }
            super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        TileEntity e;
        if (!worldIn.field_72995_K && (e = worldIn.func_175625_s(pos)) instanceof CanvasTileEntity) {
            CanvasTileEntity tile = (CanvasTileEntity)e;
            tile.func_70299_a(0, itemStack.func_77946_l());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader blockReader, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("UniqueId")) {
            list.add((ITextComponent)new StringTextComponent("A work of art"));
            long uniqueId = itemStack.func_77978_p().func_74763_f("UniqueId");
            list.add((ITextComponent)new StringTextComponent("ID = " + uniqueId));
        } else {
            list.add((ITextComponent)new StringTextComponent("For use with an easel"));
        }
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("Size")) {
            int size = itemStack.func_77978_p().func_74762_e("Size");
            list.add((ITextComponent)new StringTextComponent(""));
            if (size == 1) {
                list.add((ITextComponent)new StringTextComponent("Normal print"));
            } else if (size == 2) {
                list.add((ITextComponent)new StringTextComponent("Large print"));
            } else if (size == 3) {
                list.add((ITextComponent)new StringTextComponent("Extra Large print"));
            } else if (size == 4) {
                list.add((ITextComponent)new StringTextComponent("Massive print"));
            }
        }
    }

    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        return ((Direction)p_196271_1_.func_177229_b((Property)FACING)).func_176734_d() == p_196271_2_ && !p_196271_1_.func_196955_c((IWorldReader)p_196271_4_, p_196271_5_) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        switch ((Direction)bs.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public boolean hasTileEntity(BlockState bs) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        CanvasTileEntity toReturn = (CanvasTileEntity)CanvasTileEntity.CANVAS.func_200968_a();
        return toReturn;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, SIZE});
    }

    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        return HorizontalFaceBlock.func_220185_b((IWorldReader)p_196260_2_, (BlockPos)p_196260_3_, (Direction)((Direction)p_196260_1_.func_177229_b((Property)FACING)).func_176734_d());
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        for (Direction lvt_5_1_ : context.func_196009_e()) {
            int size;
            BlockState lvt_6_2_;
            if (lvt_5_1_.func_176740_k() == Direction.Axis.Y || !(lvt_6_2_ = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)lvt_5_1_.func_176734_d())).func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            ItemStack itemStack = context.func_195996_i();
            if (itemStack != null && itemStack.func_77973_b() == CustomBlocks.ITEM_CANVAS && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("Size") && (size = itemStack.func_77978_p().func_74762_e("Size")) > 0 && size <= MAX_SIZE) {
                lvt_6_2_ = (BlockState)lvt_6_2_.func_206870_a((Property)SIZE, (Comparable)Integer.valueOf(size));
            }
            return lvt_6_2_;
        }
        return this.func_176223_P();
    }
}

