/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.gui.chess.CheckState;
import com.dairymoose.modernlife.blocks.gui.chess.ChessScreen;
import com.dairymoose.modernlife.renderer.tileentity.ChessBoardTileEntityRenderer;
import com.dairymoose.modernlife.tileentities.ChessBoardTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ChessBoardBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);

    public ChessBoardBlock(AbstractBlock.Properties p_i48377_1_) {
        super(p_i48377_1_);
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, final BlockPos pos, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (p_225533_2_.field_72995_K) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    ChessScreen screen = new ChessScreen(pos);
                    Minecraft.func_71410_x().func_147108_a((Screen)screen);
                }
            });
        }
        return ActionResultType.CONSUME;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 5;
    }

    public boolean hasTileEntity(BlockState bs) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        ChessBoardTileEntity toReturn = (ChessBoardTileEntity)ChessBoardTileEntity.CHESS_BOARD.func_200968_a();
        return toReturn;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        TileEntity e;
        if (!worldIn.field_72995_K && (e = worldIn.func_175625_s(pos)) instanceof ChessBoardTileEntity) {
            ChessBoardTileEntity tile = (ChessBoardTileEntity)e;
            tile.func_70299_a(0, itemStack.func_77946_l());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader blockReader, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("BoardState")) {
            CompoundNBT boardState = itemStack.func_77978_p().func_74775_l("BoardState");
            int currentTurn = boardState.func_74762_e("CurrentTurn");
            String whitePlayer = boardState.func_74779_i("WhitePlayer");
            String blackPlayer = boardState.func_74779_i("BlackPlayer");
            int newCheckState = boardState.func_74762_e("NewCheckState");
            boolean gameOver = false;
            if (newCheckState == CheckState.BLACK_CHECKMATE.ordinal()) {
                gameOver = true;
                list.add((ITextComponent)new StringTextComponent("White won the game!"));
            } else if (newCheckState == CheckState.WHITE_CHECKMATE.ordinal()) {
                gameOver = true;
                list.add((ITextComponent)new StringTextComponent("Black won the game!"));
            } else {
                list.add((ITextComponent)new StringTextComponent("Game in progress..."));
            }
            list.add((ITextComponent)new StringTextComponent(""));
            list.add((ITextComponent)new StringTextComponent("Turn counter: " + currentTurn));
            list.add((ITextComponent)new StringTextComponent("White player: " + whitePlayer));
            list.add((ITextComponent)new StringTextComponent("Black player: " + blackPlayer));
            if (!gameOver) {
                boolean isWhiteTurn = boardState.func_74767_n("IsWhiteTurn");
                if (isWhiteTurn) {
                    list.add((ITextComponent)new StringTextComponent("White's turn"));
                } else {
                    list.add((ITextComponent)new StringTextComponent("Black's turn"));
                }
            }
        } else {
            list.add((ITextComponent)new StringTextComponent("Place it down and begin a new game!"));
        }
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, final BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            TileEntity lvt_6_1_ = p_196243_2_.func_175625_s(p_196243_3_);
            if (lvt_6_1_ instanceof ChessBoardTileEntity) {
                if (p_196243_2_.field_72995_K) {
                    DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                        @Override
                        public void run() {
                            ChessBoardTileEntityRenderer.stateMap.remove(p_196243_3_);
                        }
                    });
                }
                InventoryHelper.func_180175_a((World)p_196243_2_, (BlockPos)p_196243_3_, (IInventory)((ChessBoardTileEntity)lvt_6_1_));
                p_196243_2_.func_175666_e(p_196243_3_, (Block)this);
            }
            super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }
}

