/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.gui.EaselScreen;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.core.ModernLifeClient;
import com.dairymoose.modernlife.core.ModernLifeConfig;
import com.dairymoose.modernlife.tileentities.EaselTileEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.DistExecutor;

public class EaselBlock
extends Block {
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)3.5, (double)0.0, (double)3.2, (double)14.0, (double)23.0, (double)12.8);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty EMPTY = BooleanProperty.func_177716_a((String)"empty");

    public EaselBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).harvestTool(ToolType.AXE).harvestLevel(0).func_200947_a(SoundType.field_185848_a).func_200948_a(2.5f, 0.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)EMPTY, (Comparable)Boolean.TRUE));
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.field_149764_J.func_76217_h()) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.field_149764_J.func_76217_h()) {
            return 5;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader blockReader, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        list.add((ITextComponent)new StringTextComponent("Place a canvas on it to begin painting"));
    }

    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        return !p_196260_2_.func_175623_d(p_196260_3_.func_177977_b()) && !p_196260_2_.func_180495_p(p_196260_3_.func_177977_b()).func_203425_a((Block)CustomBlocks.BLOCK_EASEL);
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            TileEntity lvt_6_1_ = p_196243_2_.func_175625_s(p_196243_3_);
            if (lvt_6_1_ instanceof EaselTileEntity) {
                InventoryHelper.func_180175_a((World)p_196243_2_, (BlockPos)p_196243_3_, (IInventory)((EaselTileEntity)lvt_6_1_));
                p_196243_2_.func_175666_e(p_196243_3_, (Block)this);
            }
            super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, final World p_225533_2_, final BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (p_225533_4_.func_184614_ca().func_77973_b() == CustomBlocks.ITEM_CANVAS) {
            if (((Boolean)p_225533_1_.func_177229_b((Property)EMPTY)).booleanValue()) {
                TileEntity tileEntity;
                if (!p_225533_2_.field_72995_K && (tileEntity = p_225533_2_.func_175625_s(p_225533_3_)) instanceof EaselTileEntity) {
                    EaselTileEntity easelTileEntity = (EaselTileEntity)tileEntity;
                    if (p_225533_2_ instanceof ServerWorld && easelTileEntity != null) {
                        easelTileEntity.func_70299_a(0, p_225533_4_.func_184614_ca().func_77946_l());
                        p_225533_4_.func_184614_ca().func_190920_e(0);
                        BlockState newState = (BlockState)p_225533_1_.func_206870_a((Property)EMPTY, (Comparable)Boolean.valueOf(false));
                        p_225533_2_.func_175656_a(p_225533_3_, newState);
                        ((ServerWorld)p_225533_2_).func_184138_a(p_225533_3_, p_225533_1_, newState, 2);
                    }
                }
                return ActionResultType.CONSUME;
            }
        } else if (p_225533_4_.func_184614_ca().func_77973_b() == Items.field_190931_a && p_225533_4_.func_226271_bk_()) {
            if (!((Boolean)p_225533_1_.func_177229_b((Property)EMPTY)).booleanValue()) {
                if (!p_225533_2_.field_72995_K) {
                    TileEntity tileEntity = p_225533_2_.func_175726_f(p_225533_3_).func_175625_s(p_225533_3_);
                    field_196273_d.debug("tileEntity = " + tileEntity);
                    if (tileEntity instanceof EaselTileEntity) {
                        EaselTileEntity easelTileEntity = (EaselTileEntity)tileEntity;
                        if (p_225533_2_ instanceof ServerWorld && easelTileEntity != null) {
                            Object image = null;
                            ItemStack canvasItem = easelTileEntity.func_70301_a(0).func_77946_l();
                            easelTileEntity.func_70299_a(0, ItemStack.field_190927_a);
                            p_225533_2_.func_175656_a(p_225533_3_, (BlockState)p_225533_1_.func_206870_a((Property)EMPTY, (Comparable)Boolean.valueOf(true)));
                            ItemStack itemStack = canvasItem;
                            if (itemStack != null) {
                                p_225533_4_.func_184611_a(Hand.MAIN_HAND, itemStack);
                            }
                        }
                    }
                }
                return ActionResultType.CONSUME;
            }
        } else if (!((Boolean)p_225533_1_.func_177229_b((Property)EMPTY)).booleanValue()) {
            if (p_225533_2_.field_72995_K) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                    @Override
                    public void run() {
                        EaselScreen screen = new EaselScreen(p_225533_2_, p_225533_3_);
                        TileEntity tileEntity = p_225533_2_.func_175625_s(p_225533_3_);
                        field_196273_d.debug("tileEntity = " + tileEntity);
                        if (tileEntity instanceof EaselTileEntity) {
                            EaselTileEntity easelTileEntity = (EaselTileEntity)tileEntity;
                            ItemStack item = easelTileEntity.func_70301_a(0);
                            field_196273_d.debug("item = " + item);
                            if (item.func_77973_b() == CustomBlocks.ITEM_CANVAS) {
                                field_196273_d.debug("canvas = " + tileEntity);
                                if (item.func_77942_o() && item.func_77978_p().func_74764_b("UniqueId")) {
                                    long uniqueId = item.func_77978_p().func_74763_f("UniqueId");
                                    byte[] imageData = ModernLifeClient.getCanvasData(uniqueId);
                                    if (imageData != null && imageData.length > 0) {
                                        if (item.func_77978_p().func_74764_b("TextureSize")) {
                                            int tex = item.func_77978_p().func_74762_e("TextureSize");
                                            screen.setTextureSize(tex);
                                        }
                                        screen.setInitialData(imageData);
                                        field_196273_d.debug("initialData = " + imageData.length);
                                    }
                                } else {
                                    field_196273_d.debug("empty canvas size = " + ModernLifeConfig.CLIENT.emptyCanvasEaselSize.get());
                                    screen.setTextureSize((Integer)ModernLifeConfig.CLIENT.emptyCanvasEaselSize.get());
                                }
                            }
                        }
                        screen.setBlockPos(p_225533_3_);
                        Minecraft.func_71410_x().func_147108_a((Screen)screen);
                    }
                });
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public boolean hasTileEntity(BlockState bs) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        EaselTileEntity toReturn = (EaselTileEntity)EaselTileEntity.EASEL.func_200968_a();
        return toReturn;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, EMPTY});
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        switch ((Direction)bs.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }
}

