/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.AbstractPanelBlock;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class GlassPanelBlock
extends AbstractPanelBlock {
    protected static final VoxelShape SHAPE_FLOOR_NORTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WALL_NORTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WALL_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WALL_NORTH);
    protected static final VoxelShape SHAPE_WALL_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WALL_EAST);
    protected static final VoxelShape SHAPE_WALL_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WALL_SOUTH);
    protected static final VoxelShape SHAPE_CEILING_NORTH = Stream.of(Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public GlassPanelBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)FACE, (Comparable)AttachFace.FLOOR));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, FACE});
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        switch ((AttachFace)bs.func_177229_b((Property)FACE)) {
            case FLOOR: {
                return SHAPE_FLOOR_NORTH;
            }
            case WALL: {
                switch ((Direction)bs.func_177229_b((Property)FACING)) {
                    case NORTH: {
                        return SHAPE_WALL_NORTH;
                    }
                    case EAST: {
                        return SHAPE_WALL_EAST;
                    }
                    case WEST: {
                        return SHAPE_WALL_WEST;
                    }
                    case SOUTH: {
                        return SHAPE_WALL_SOUTH;
                    }
                }
            }
            case CEILING: {
                return SHAPE_CEILING_NORTH;
            }
        }
        return SHAPE_FLOOR_NORTH;
    }
}

