/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.AbstractPanelBlock;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.LavaFluid;
import net.minecraft.fluid.WaterFluid;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GrateBlock
extends AbstractPanelBlock
implements IWaterLoggable {
    private boolean allowAllLiquids = true;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty LEVEL = IntegerProperty.func_177719_a((String)"level", (int)0, (int)8);
    public static final EnumProperty<FluidType> FLUIDTYPE = EnumProperty.func_177709_a((String)"fluidtype", FluidType.class);
    private static final int MS_PER_TICK = 50;
    private static final float GRATE_SLOWDOWN_FACTOR = 1.0f;
    private static final HashSet<BlockPos> removable = new HashSet();
    private static final HashSet<BlockPos> respawning = new HashSet();
    private static final HashMap<BlockPos, Integer> waterLevel = new HashMap();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    protected static final VoxelShape SHAPE_FLOOR_NORTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WALL_NORTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WALL_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WALL_NORTH);
    protected static final VoxelShape SHAPE_WALL_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WALL_EAST);
    protected static final VoxelShape SHAPE_WALL_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WALL_SOUTH);
    protected static final VoxelShape SHAPE_CEILING_NORTH = Stream.of(Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public GrateBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)FACE, (Comparable)AttachFace.FLOOR)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public Fluid func_204508_a(IWorld p_204508_1_, BlockPos p_204508_2_, BlockState p_204508_3_) {
        Fluid fluid = super.func_204508_a(p_204508_1_, p_204508_2_, p_204508_3_);
        BlockState newState = p_204508_1_.func_180495_p(p_204508_2_);
        if (!((Boolean)newState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            field_196273_d.debug("Set level to 0");
            p_204508_1_.func_180501_a(p_204508_2_, (BlockState)newState.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)), 3);
        }
        return fluid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader blockReader, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        list.add((ITextComponent)new StringTextComponent("Allows water and items to flow through freely"));
    }

    public boolean func_204509_a(IWorld p_204509_1_, BlockPos p_204509_2_, BlockState p_204509_3_, FluidState p_204509_4_) {
        if (p_204509_4_.func_206886_c() instanceof WaterFluid || p_204509_4_.func_206886_c() instanceof LavaFluid) {
            if (p_204509_1_ instanceof ServerWorld) {
                ServerWorld world = (ServerWorld)p_204509_1_;
                FluidType f = FluidType.water;
                if (p_204509_4_.func_206886_c() instanceof WaterFluid) {
                    f = FluidType.water;
                } else if (p_204509_4_.func_206886_c() instanceof LavaFluid) {
                    f = FluidType.lava;
                }
                int newLevel = p_204509_4_.func_206882_g();
                field_196273_d.debug("placeLiquid update: " + p_204509_4_);
                if (p_204509_4_.func_206889_d()) {
                    world.func_180501_a(p_204509_2_, (BlockState)((BlockState)((BlockState)p_204509_3_.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a(FLUIDTYPE, (Comparable)((Object)f))).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(newLevel)), 3);
                } else {
                    world.func_180501_a(p_204509_2_, (BlockState)((BlockState)p_204509_3_.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(newLevel))).func_206870_a(FLUIDTYPE, (Comparable)((Object)f)), 3);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_204510_a(IBlockReader p_204510_1_, BlockPos p_204510_2_, BlockState p_204510_3_, Fluid p_204510_4_) {
        if (this.allowAllLiquids) {
            return true;
        }
        return super.func_204510_a(p_204510_1_, p_204510_2_, p_204510_3_, p_204510_4_);
    }

    public BlockState func_196271_a(final BlockState grate, Direction dir, BlockState updater, final IWorld world, BlockPos gratePos, BlockPos updaterPos) {
        field_196273_d.debug("world = " + world);
        field_196273_d.debug("updateShape, bs1: " + grate + " with pos = " + gratePos);
        field_196273_d.debug("updateShape, bs2: " + updater + " with pos = " + updaterPos);
        field_196273_d.debug("direction = " + dir);
        BlockPos.Mutable originalGratePos = gratePos.func_239590_i_();
        GrateBlock grateBlock = this;
        this.scheduler.schedule(new Runnable((BlockPos)originalGratePos, grateBlock){
            final /* synthetic */ BlockPos val$originalGratePos;
            final /* synthetic */ GrateBlock val$grateBlock;
            {
                this.val$originalGratePos = blockPos;
                this.val$grateBlock = grateBlock;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Method newLiquidMethod = null;
                try {
                    int currentLevel = (Integer)grate.func_177229_b((Property)LEVEL);
                    try {
                        newLiquidMethod = FlowingFluid.class.getDeclaredMethod("func_205576_a", IWorldReader.class, BlockPos.class, BlockState.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (newLiquidMethod == null) {
                        newLiquidMethod = FlowingFluid.class.getDeclaredMethod("getNewLiquid", IWorldReader.class, BlockPos.class, BlockState.class);
                    }
                    newLiquidMethod.setAccessible(true);
                    FluidState newFluid = (FluidState)newLiquidMethod.invoke((Object)Fluids.field_207212_b, world, this.val$originalGratePos, grate);
                    int newLevel = newFluid.func_206882_g();
                    if (newLevel < currentLevel) {
                        BlockState newGrateState = world.func_180495_p(this.val$originalGratePos);
                        if (newGrateState.func_203425_a(CustomBlocks.BLOCK_METAL_GRATE) && !((Boolean)newGrateState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                            world.func_180501_a(this.val$originalGratePos, (BlockState)grate.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(newLevel)), 3);
                        }
                        field_196273_d.debug("Set to new state: " + grate.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(newLevel)));
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                    field_196273_d.error("getNewLiquid error", (Throwable)e1);
                }
                finally {
                    this.val$grateBlock.allowAllLiquids = true;
                }
            }
        }, (long)((int)((float)(50 * updater.func_204520_s().func_206886_c().func_205569_a((IWorldReader)world)) * 1.0f)), TimeUnit.MILLISECONDS);
        return grate;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader blockReader, BlockPos blockPos, ISelectionContext ctx) {
        if (ctx == ISelectionContext.func_216377_a() || ctx.getEntity() != null && (ctx.getEntity() instanceof ItemEntity || ctx.getEntity() instanceof ExperienceOrbEntity)) {
            return VoxelShapes.func_197880_a();
        }
        return super.func_220071_b(state, blockReader, blockPos, ctx);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        FluidType f = FluidType.water;
        World world = context.func_195991_k();
        BlockState oldState = world.func_180495_p(pos = context.func_195995_a());
        if (oldState.func_204520_s().func_206886_c() instanceof WaterFluid) {
            f = FluidType.water;
        } else if (oldState.func_204520_s().func_206886_c() instanceof LavaFluid) {
            f = FluidType.lava;
        }
        boolean waterlogged = false;
        if (!oldState.func_204520_s().func_206888_e() && oldState.func_204520_s().func_206889_d()) {
            waterlogged = true;
        }
        return (BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(oldState.func_204520_s().func_206882_g()))).func_206870_a(FLUIDTYPE, (Comparable)((Object)f))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    @Deprecated
    public void func_220082_b(final BlockState newState, final World world, final BlockPos pos, BlockState oldState, boolean p_220082_5_) {
        int level;
        field_196273_d.debug("onPlace newState = " + newState + ", bool=" + p_220082_5_);
        if (!(oldState.func_177230_c() instanceof FlowingFluidBlock) || !oldState.func_204520_s().func_206888_e()) {
            // empty if block
        }
        if ((level = ((Integer)newState.func_177229_b((Property)LEVEL)).intValue()) >= 0) {
            GrateBlock thisBlock = this;
            this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    FlowingFluid fluid = Fluids.field_204546_a;
                    if (newState.func_177229_b(FLUIDTYPE) == FluidType.water) {
                        fluid = Fluids.field_204546_a;
                    } else if (newState.func_177229_b(FLUIDTYPE) == FluidType.lava) {
                        fluid = Fluids.field_204547_b;
                    }
                    int level = (Integer)newState.func_177229_b((Property)LEVEL);
                    Method m = null;
                    try {
                        try {
                            m = FlowingFluid.class.getDeclaredMethod("func_205575_a", IWorld.class, BlockPos.class, FluidState.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (m == null) {
                            m = FlowingFluid.class.getDeclaredMethod("spread", IWorld.class, BlockPos.class, FluidState.class);
                        }
                        m.setAccessible(true);
                        FluidState fs = Fluids.field_204541_a.func_207188_f();
                        if (level > 0 && fluid instanceof FlowingFluid) {
                            fs = fluid.func_207207_a(level, false);
                            m.invoke((Object)fluid, world, pos, fs);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        field_196273_d.error("Fluid error", (Throwable)e);
                    }
                    world.func_195593_d(pos, newState.func_177230_c());
                }
            }, (long)(50 * this.func_204507_t(newState).func_206886_c().func_205569_a((IWorldReader)world)), TimeUnit.MILLISECONDS);
        } else {
            world.func_195593_d(pos, newState.func_177230_c());
        }
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && state.func_177229_b(FLUIDTYPE) == FluidType.water) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && state.func_177229_b(FLUIDTYPE) == FluidType.lava) {
            return Fluids.field_204547_b.func_207204_a(false);
        }
        if ((Integer)state.func_177229_b((Property)LEVEL) > 0 && state.func_177229_b(FLUIDTYPE) == FluidType.water) {
            return Fluids.field_204546_a.func_207207_a(((Integer)state.func_177229_b((Property)LEVEL)).intValue(), false);
        }
        if ((Integer)state.func_177229_b((Property)LEVEL) > 0 && state.func_177229_b(FLUIDTYPE) == FluidType.lava) {
            return Fluids.field_204547_b.func_207207_a(((Integer)state.func_177229_b((Property)LEVEL)).intValue(), false);
        }
        return Fluids.field_204541_a.func_207188_f();
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if ((Integer)state.func_177229_b((Property)LEVEL) > 0) {
            // empty if block
        }
        field_196273_d.debug("Removed by played");
        removable.add(pos);
        return super.removedByPlayer(state, world, pos, null, willHarvest, fluid);
    }

    public void func_196243_a(BlockState oldState, World p_196243_2_, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        field_196273_d.debug("Being changed to : " + newState);
        if (newState.func_203425_a(Blocks.field_150355_j) || newState.func_203425_a(Blocks.field_150350_a)) {
            field_196273_d.debug("Respawn: " + oldState);
        }
        if (newState.func_203425_a(Blocks.field_150353_l)) {
            // empty if block
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, FACE, WATERLOGGED, LEVEL, FLUIDTYPE});
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        switch ((AttachFace)bs.func_177229_b((Property)FACE)) {
            case FLOOR: {
                return SHAPE_FLOOR_NORTH;
            }
            case WALL: {
                switch ((Direction)bs.func_177229_b((Property)FACING)) {
                    case NORTH: {
                        return SHAPE_WALL_NORTH;
                    }
                    case EAST: {
                        return SHAPE_WALL_EAST;
                    }
                    case WEST: {
                        return SHAPE_WALL_WEST;
                    }
                    case SOUTH: {
                        return SHAPE_WALL_SOUTH;
                    }
                }
            }
            case CEILING: {
                return SHAPE_CEILING_NORTH;
            }
        }
        return SHAPE_FLOOR_NORTH;
    }

    public static enum FluidType implements IStringSerializable
    {
        water,
        lava;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

