/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.tileentities.NightStandTileEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class NightStandBlock
extends Block {
    protected static final VoxelShape SHAPE_SOUTH = Stream.of(Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), Block.func_208617_a((double)5.0, (double)11.6, (double)15.0, (double)11.0, (double)12.6, (double)16.0), Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)1.0), Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)2.0, (double)14.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)1.0), Block.func_208617_a((double)15.0, (double)0.0, (double)13.0, (double)16.0, (double)2.0, (double)14.0), Block.func_208617_a((double)5.0, (double)5.475, (double)14.0, (double)6.0, (double)6.475, (double)15.0), Block.func_208617_a((double)5.0, (double)5.475, (double)15.0, (double)11.0, (double)6.475, (double)16.0), Block.func_208617_a((double)10.0, (double)5.475, (double)14.0, (double)11.0, (double)6.475, (double)15.0), Block.func_208617_a((double)5.0, (double)11.6, (double)14.0, (double)6.0, (double)12.6, (double)15.0), Block.func_208617_a((double)10.0, (double)11.6, (double)14.0, (double)11.0, (double)12.6, (double)15.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    protected static final VoxelShape SHAPE_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected String containerDisplayLabel = "Night Stand";
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader blockReader, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        list.add((ITextComponent)new StringTextComponent("Stores up to 18 items"));
    }

    public NightStandBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).harvestTool(ToolType.AXE).harvestLevel(1).func_200947_a(SoundType.field_185848_a).func_200943_b(1.5f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.field_149764_J.func_76217_h()) {
            return 20;
        }
        return 0;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.field_149764_J.func_76217_h()) {
            return 5;
        }
        return 0;
    }

    public NightStandBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            TileEntity lvt_6_1_ = p_196243_2_.func_175625_s(p_196243_3_);
            if (lvt_6_1_ instanceof NightStandTileEntity) {
                InventoryHelper.func_180175_a((World)p_196243_2_, (BlockPos)p_196243_3_, (IInventory)((NightStandTileEntity)lvt_6_1_));
                p_196243_2_.func_175666_e(p_196243_3_, (Block)this);
            }
            super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public INamedContainerProvider func_220052_b(BlockState p_220052_1_, final World p_220052_2_, final BlockPos p_220052_3_) {
        return new INamedContainerProvider(){

            public Container createMenu(int paramInt, PlayerInventory paramPlayerInventory, PlayerEntity paramPlayerEntity) {
                TileEntity tileEntity = p_220052_2_.func_175625_s(p_220052_3_);
                if (tileEntity instanceof NightStandTileEntity) {
                    NightStandTileEntity nightStandTileEntity = (NightStandTileEntity)tileEntity;
                    return new ChestContainer(ContainerType.field_221508_b, paramInt, paramPlayerInventory, (IInventory)nightStandTileEntity, 2);
                }
                return null;
            }

            public ITextComponent func_145748_c_() {
                return new StringTextComponent(NightStandBlock.this.containerDisplayLabel);
            }
        };
    }

    public boolean hasTileEntity(BlockState bs) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        NightStandTileEntity toReturn = (NightStandTileEntity)NightStandTileEntity.NIGHT_STAND.func_200968_a();
        return toReturn;
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        INamedContainerProvider lvt_7_1_ = this.func_220052_b(p_225533_1_, p_225533_2_, p_225533_3_);
        if (lvt_7_1_ != null) {
            p_225533_4_.func_213829_a(lvt_7_1_);
        }
        return ActionResultType.CONSUME;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        switch ((Direction)bs.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }
}

