/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.gui.WirelessPowerScreen;
import com.dairymoose.modernlife.tileentities.IChannelHolder;
import com.dairymoose.modernlife.tileentities.PowerReceiverTileEntity;
import com.dairymoose.modernlife.tileentities.PowerTransmitterTileEntity;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class PowerReceiverBlock
extends Block {
    protected static final VoxelShape SHAPE = Stream.of(Block.func_208617_a((double)6.5, (double)2.0, (double)6.5, (double)9.5, (double)5.0, (double)9.5), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.func_208617_a((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader blockReader, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        list.add((ITextComponent)new StringTextComponent("Receives power on the selected channel from all transmitters"));
        list.add((ITextComponent)new StringTextComponent("Right click block to change current channel"));
    }

    public PowerReceiverBlock(AbstractBlock.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.SOUTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, final World p_225533_2_, final BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (p_225533_2_.field_72995_K) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    TileEntity tileEntity = p_225533_2_.func_175625_s(p_225533_3_);
                    if (tileEntity instanceof IChannelHolder) {
                        IChannelHolder channelHolder = (IChannelHolder)tileEntity;
                        WirelessPowerScreen screen = new WirelessPowerScreen(p_225533_3_, channelHolder.getCurrentChannel());
                        Minecraft.func_71410_x().func_147108_a((Screen)screen);
                    }
                }
            });
        }
        return ActionResultType.CONSUME;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof PowerReceiverTileEntity) {
            PowerReceiverTileEntity receiver = (PowerReceiverTileEntity)tileEntity;
            receiver.setCurrentChannel(0);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return PowerReceiverTileEntity.POWER_RECEIVER.func_200968_a();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof PowerReceiverTileEntity) {
            PowerReceiverTileEntity receiver = (PowerReceiverTileEntity)entity;
            field_196273_d.debug("remove receiver from channel: " + receiver.getCurrentChannel());
            receiver.removeFromChannel(receiver.getCurrentChannel());
        }
        if (!p_196243_5_ && !state.func_203425_a(p_196243_4_.func_177230_c())) {
            this.updateNeighbours(state, world, pos);
            super.func_196243_a(state, world, pos, p_196243_4_, p_196243_5_);
        }
    }

    private int getPowerFromTransmitter(BlockPos pos, IBlockReader reader) {
        TileEntity entity = reader.func_175625_s(pos);
        field_196273_d.debug("get power: " + entity);
        if (entity instanceof PowerReceiverTileEntity) {
            field_196273_d.debug("entity is instance");
            PowerReceiverTileEntity receiver = (PowerReceiverTileEntity)entity;
            Set<PowerTransmitterTileEntity> transmitters = PowerTransmitterTileEntity.perChannelPowerTransmitters.get(receiver.getCurrentChannel());
            int powerSum = 0;
            if (transmitters != null) {
                field_196273_d.debug("found " + transmitters.size() + " transmitters for channel " + receiver.getCurrentChannel());
                for (PowerTransmitterTileEntity transmitter : transmitters) {
                    BlockState state = transmitter.func_195044_w();
                    powerSum += ((Integer)state.func_177229_b((Property)BlockStateProperties.field_208136_ak)).intValue();
                }
                if (powerSum > 15) {
                    powerSum = 15;
                }
                field_196273_d.debug("got power sum = " + powerSum);
            } else {
                field_196273_d.debug("transmitters is null for channel " + receiver.getCurrentChannel());
            }
            return powerSum;
        }
        return 0;
    }

    public boolean func_220074_n(BlockState p_220074_1_) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader reader, BlockPos pos, Direction p_180656_4_) {
        field_196273_d.debug("getSignal for state=" + state + " and pos=" + pos);
        return this.getPowerFromTransmitter(pos, reader);
    }

    public int func_176211_b(BlockState p_176211_1_, IBlockReader p_176211_2_, BlockPos p_176211_3_, Direction p_176211_4_) {
        field_196273_d.debug("getDirectSignal");
        return this.getPowerFromTransmitter(p_176211_3_, p_176211_2_);
    }

    private void updateNeighbours(BlockState p_196378_1_, World p_196378_2_, BlockPos p_196378_3_) {
        p_196378_2_.func_195593_d(p_196378_3_, (Block)this);
        p_196378_2_.func_195593_d(p_196378_3_.func_177972_a(((Direction)p_196378_1_.func_177229_b((Property)FACING)).func_176734_d()), (Block)this);
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        return SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        for (Direction lvt_5_1_ : context.func_196009_e()) {
            BlockState lvt_6_2_;
            if (lvt_5_1_.func_176740_k() == Direction.Axis.Y || !(lvt_6_2_ = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)lvt_5_1_.func_176734_d())).func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return lvt_6_2_;
        }
        return this.func_176223_P();
    }
}

