/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.gui.WirelessPowerScreen;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.IChannelHolder;
import com.dairymoose.modernlife.tileentities.PowerTransmitterTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class PowerTransmitterBlock
extends Block {
    public static final IntegerProperty POWER;
    public static final DirectionProperty FACING;

    public PowerTransmitterBlock(AbstractBlock.Properties p_i48377_1_) {
        super(p_i48377_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader blockReader, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        list.add((ITextComponent)new StringTextComponent("Transmits power on the selected channel to all receivers"));
        list.add((ITextComponent)new StringTextComponent("Right click block to change current channel"));
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, final World p_225533_2_, final BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (p_225533_2_.field_72995_K) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    TileEntity tileEntity = p_225533_2_.func_175625_s(p_225533_3_);
                    if (tileEntity instanceof IChannelHolder) {
                        IChannelHolder channelHolder = (IChannelHolder)tileEntity;
                        WirelessPowerScreen screen = new WirelessPowerScreen(p_225533_3_, channelHolder.getCurrentChannel());
                        Minecraft.func_71410_x().func_147108_a((Screen)screen);
                    }
                }
            });
        }
        return ActionResultType.CONSUME;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof PowerTransmitterTileEntity) {
            PowerTransmitterTileEntity transmitter = (PowerTransmitterTileEntity)tileEntity;
            transmitter.setCurrentChannel(0);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWER});
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return PowerTransmitterTileEntity.POWER_TRANSMITTER.func_200968_a();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader blockReader, BlockPos blockPos, ISelectionContext ctx) {
        return super.func_220071_b(state, blockReader, blockPos, ctx);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof PowerTransmitterTileEntity) {
            PowerTransmitterTileEntity transmitter = (PowerTransmitterTileEntity)entity;
            field_196273_d.debug("remove transmitter from channel: " + transmitter.getCurrentChannel());
            transmitter.removeFromChannel(transmitter.getCurrentChannel());
            transmitter.updateReceivers(world);
        }
        super.func_196243_a(state, world, pos, p_196243_4_, p_196243_5_);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighbor, boolean p_220069_6_) {
        TileEntity entity;
        if (world.func_180495_p(neighbor).func_203425_a(CustomBlocks.BLOCK_POWER_RECEIVER)) {
            return;
        }
        if (state.func_203425_a(CustomBlocks.BLOCK_POWER_TRANSMITTER) && (entity = world.func_175625_s(pos)) instanceof PowerTransmitterTileEntity) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(world.func_175687_A(pos))), 2);
            PowerTransmitterTileEntity transmitter = (PowerTransmitterTileEntity)entity;
            field_196273_d.debug("add transmitter to channel: " + transmitter.getCurrentChannel());
            transmitter.addToChannel(transmitter.getCurrentChannel());
            transmitter.updateReceivers(world);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(context.func_195991_k().func_175687_A(context.func_195995_a())));
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    static {
        FACING = BlockStateProperties.field_208157_J;
        POWER = BlockStateProperties.field_208136_ak;
    }
}

