/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.StandardHorizontalBlock;
import com.dairymoose.modernlife.blocks.gui.PrinterScreen;
import com.dairymoose.modernlife.core.CustomBlocks;
import com.dairymoose.modernlife.tileentities.PrinterTileEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class PrinterBlock
extends StandardHorizontalBlock {
    protected static final VoxelShape SHAPE_SOUTH = Stream.of(Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)8.0, (double)13.0), Block.func_208617_a((double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    protected static final VoxelShape SHAPE_NORTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_WEST);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);

    public PrinterBlock(AbstractBlock.Properties p_i48377_1_) {
        super(p_i48377_1_);
    }

    public boolean hasTileEntity(BlockState bs) {
        return true;
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            TileEntity lvt_6_1_ = p_196243_2_.func_175625_s(p_196243_3_);
            if (lvt_6_1_ instanceof PrinterTileEntity) {
                InventoryHelper.func_180175_a((World)p_196243_2_, (BlockPos)p_196243_3_, (IInventory)((PrinterTileEntity)lvt_6_1_));
                p_196243_2_.func_175666_e(p_196243_3_, (Block)this);
            }
            super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        PrinterTileEntity toReturn = (PrinterTileEntity)PrinterTileEntity.PRINTER.func_200968_a();
        return toReturn;
    }

    public INamedContainerProvider func_220052_b(BlockState p_220052_1_, final World p_220052_2_, final BlockPos p_220052_3_) {
        return new INamedContainerProvider(){

            public Container createMenu(int paramInt, PlayerInventory paramPlayerInventory, PlayerEntity paramPlayerEntity) {
                TileEntity tileEntity = p_220052_2_.func_175625_s(p_220052_3_);
                if (tileEntity instanceof PrinterTileEntity) {
                    PrinterTileEntity printerTileEntity = (PrinterTileEntity)tileEntity;
                    return new ChestContainer(ContainerType.field_221509_c, paramInt, paramPlayerInventory, (IInventory)printerTileEntity, 3);
                }
                return null;
            }

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Printer");
            }
        };
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, final BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        INamedContainerProvider lvt_7_1_;
        ItemStack itemStack = player.func_184614_ca();
        if (itemStack.func_77973_b() == CustomBlocks.ITEM_CAMERA || itemStack.func_77973_b() == CustomBlocks.ITEM_CANVAS) {
            if (itemStack.func_77973_b() == CustomBlocks.ITEM_CAMERA && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("ImageList")) {
                int photoCount = 0;
                INBT imageListNbt = itemStack.func_77978_p().func_74781_a("ImageList");
                ListNBT imageList = null;
                if (imageListNbt instanceof ListNBT) {
                    imageList = (ListNBT)imageListNbt;
                    photoCount = imageList.size();
                }
                if (photoCount > 0) {
                    if (world.field_72995_K) {
                        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                            @Override
                            public void run() {
                                Minecraft.func_71410_x().func_147108_a((Screen)new PrinterScreen(pos));
                            }
                        });
                    }
                } else {
                    INamedContainerProvider lvt_7_1_2 = this.func_220052_b(blockState, world, pos);
                    if (lvt_7_1_2 != null) {
                        player.func_213829_a(lvt_7_1_2);
                    }
                }
            } else if (itemStack.func_77973_b() == CustomBlocks.ITEM_CANVAS && world.field_72995_K) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                    @Override
                    public void run() {
                        Minecraft.func_71410_x().func_147108_a((Screen)new PrinterScreen(pos));
                    }
                });
            }
        } else if (!world.field_72995_K && (lvt_7_1_ = this.func_220052_b(blockState, world, pos)) != null) {
            player.func_213829_a(lvt_7_1_);
        }
        return ActionResultType.CONSUME;
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        switch ((Direction)bs.func_177229_b((Property)field_185512_D)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }
}

