/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.modernlife.blocks;

import com.dairymoose.modernlife.blocks.gui.RadiatorScreen;
import com.dairymoose.modernlife.tileentities.RadiatorTileEntity;
import com.dairymoose.modernlife.util.ModernLifeUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.DistExecutor;

public class RadiatorBlock
extends Block
implements IWaterLoggable {
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)2.0, (double)0.0, (double)5.0, (double)15.0, (double)13.0, (double)12.0);
    protected static final VoxelShape SHAPE_EAST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_NORTH);
    protected static final VoxelShape SHAPE_SOUTH = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_EAST);
    protected static final VoxelShape SHAPE_WEST = ModernLifeUtil.RotateVoxelShapeClockwise(SHAPE_SOUTH);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<HeatType> HEAT = EnumProperty.func_177709_a((String)"heat", HeatType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public RadiatorBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151574_g).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200947_a(SoundType.field_185852_e).func_200948_a(3.5f, 10.0f).func_235838_a_(RadiatorBlock::getLightValueInternal));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HEAT, (Comparable)((Object)HeatType.off))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        return !p_196260_2_.func_175623_d(p_196260_3_.func_177977_b());
    }

    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    public boolean hasTileEntity(BlockState bs) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return RadiatorTileEntity.RADIATOR.func_200968_a();
    }

    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (((Boolean)p_196271_1_.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            p_196271_4_.func_205219_F_().func_205360_a(p_196271_5_, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)p_196271_4_));
        }
        return super.func_196271_a(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, final World p_225533_2_, final BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (p_225533_2_.field_72995_K) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    RadiatorScreen screen = new RadiatorScreen(p_225533_2_, p_225533_3_);
                    Minecraft.func_71410_x().func_147108_a((Screen)screen);
                }
            });
        }
        return ActionResultType.CONSUME;
    }

    public static int getLightValueInternal(BlockState state) {
        if (state.func_177229_b(HEAT) == HeatType.low) {
            return 3;
        }
        if (state.func_177229_b(HEAT) == HeatType.medium) {
            return 5;
        }
        if (state.func_177229_b(HEAT) == HeatType.high) {
            return 7;
        }
        return 0;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return RadiatorBlock.getLightValueInternal(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack itemStack, @Nullable IBlockReader blockReader, List<ITextComponent> list, ITooltipFlag tooltipFlag) {
        list.add((ITextComponent)new StringTextComponent("Right click placed radiator to activate"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEmissiveRendering(BlockState blockState) {
        if (blockState.func_177229_b(HEAT) == HeatType.low) {
            return true;
        }
        if (blockState.func_177229_b(HEAT) == HeatType.medium) {
            return true;
        }
        return blockState.func_177229_b(HEAT) == HeatType.high;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, HEAT, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState bs, IBlockReader reader, BlockPos pos, ISelectionContext sel) {
        switch ((Direction)bs.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public static enum HeatType implements IStringSerializable
    {
        off,
        low,
        medium,
        high;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

